# Directory containing class headers.
SET(VTK_RENDERING_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.2")

# Classes in vtkRendering.
SET(VTK_RENDERING_CLASSES
  "vtkAbstractMapper3D"
  "vtkAbstractPicker"
  "vtkAbstractPropPicker"
  "vtkAbstractVolumeMapper"
  "vtkActorCollection"
  "vtkActor"
  "vtkAreaPicker"
  "vtkAssembly"
  "vtkAxisActor2D"
  "vtkCamera"
  "vtkCameraInterpolator"
  "vtkCellCenterDepthSort"
  "vtkCellPicker"
  "vtkChooserPainter"
  "vtkClipPlanesPainter"
  "vtkCoincidentTopologyResolutionPainter"
  "vtkCompositePainter"
  "vtkCompositePolyDataMapper2"
  "vtkCompositePolyDataMapper"
  "vtkCullerCollection"
  "vtkCuller"
  "vtkDataSetMapper"
  "vtkDefaultPainter"
  "vtkDisplayListPainter"
  "vtkDynamic2DLabelMapper"
  "vtkExporter"
  "vtkFollower"
  "vtkFrustumCoverageCuller"
  "vtkGenericRenderWindowInteractor"
  "vtkGenericVertexAttributeMapping"
  "vtkGraphicsFactory"
  "vtkHierarchicalPolyDataMapper"
  "vtkIdentColoredPainter"
  "vtkImageActor"
  "vtkImageMapper"
  "vtkImageViewer2"
  "vtkImageViewer"
  "vtkImagingFactory"
  "vtkImporter"
  "vtkInteractorEventRecorder"
  "vtkInteractorObserver"
  "vtkInteractorStyle"
  "vtkInteractorStyleFlight"
  "vtkInteractorStyleImage"
  "vtkInteractorStyleJoystickActor"
  "vtkInteractorStyleJoystickCamera"
  "vtkInteractorStyleRubberBand2D"
  "vtkInteractorStyleRubberBand3D"
  "vtkInteractorStyleRubberBandPick"
  "vtkInteractorStyleRubberBandZoom"
  "vtkInteractorStyleSwitch"
  "vtkInteractorStyleTerrain"
  "vtkInteractorStyleTrackballActor"
  "vtkInteractorStyleTrackballCamera"
  "vtkInteractorStyleTrackball"
  "vtkInteractorStyleUnicam"
  "vtkInteractorStyleUser"
  "vtkIVExporter"
  "vtkLabeledDataMapper"
  "vtkLeaderActor2D"
  "vtkLightCollection"
  "vtkLight"
  "vtkLightingPainter"
  "vtkLightKit"
  "vtkLinesPainter"
  "vtkLODActor"
  "vtkLODProp3D"
  "vtkMapperCollection"
  "vtkMapper"
  "vtkOBJExporter"
  "vtkObserverMediator"
  "vtkOOGLExporter"
  "vtkPainter"
  "vtkPainterDeviceAdapter"
  "vtkPainterPolyDataMapper"
  "vtkParallelCoordinatesActor"
  "vtkPicker"
  "vtkPointPicker"
  "vtkPointsPainter"
  "vtkPOVExporter"
  "vtkPolyDataMapper2D"
  "vtkPolyDataMapper"
  "vtkPolyDataPainter"
  "vtkPolygonsPainter"
  "vtkPrimitivePainter"
  "vtkProp3DCollection"
  "vtkProp3D"
  "vtkProperty"
  "vtkPropPicker"
  "vtkQuadricLODActor"
  "vtkQuaternionInterpolator"
  "vtkRenderedAreaPicker"
  "vtkRendererCollection"
  "vtkRenderer"
  "vtkRendererSource"
  "vtkRenderWindowCollection"
  "vtkRenderWindow"
  "vtkRenderWindowInteractor"
  "vtkRepresentationPainter"
  "vtkScalarBarActor"
  "vtkScalarsToColorsPainter"
  "vtkScaledTextActor"
  "vtkScenePicker"
  "vtkSelectVisiblePoints"
  "vtkShader"
  "vtkShaderDeviceAdapter"
  "vtkShaderProgram"
  "vtkStandardPolyDataPainter"
  "vtkTesting"
  "vtkTextActor3D"
  "vtkTextActor"
  "vtkTextMapper"
  "vtkTextProperty"
  "vtkTexture"
  "vtkTexturedActor2D"
  "vtkTransformInterpolator"
  "vtkTStripsPainter"
  "vtkTupleInterpolator"
  "vtkVisibilitySort"
  "vtkVisibleCellSelector"
  "vtkVolumeCollection"
  "vtkVolume"
  "vtkVolumeProperty"
  "vtkVRMLExporter"
  "vtkWindowToImageFilter"
  "vtkWorldPointPicker"
  "vtkFreeTypeUtilities"
  "vtkOpenGLActor"
  "vtkOpenGLCamera"
  "vtkOpenGLClipPlanesPainter"
  "vtkOpenGLCoincidentTopologyResolutionPainter"
  "vtkOpenGLDisplayListPainter"
  "vtkOpenGLExtensionManager"
  "vtkOpenGLImageActor"
  "vtkOpenGLImageMapper"
  "vtkOpenGLLight"
  "vtkOpenGLLightingPainter"
  "vtkOpenGLPainterDeviceAdapter"
  "vtkOpenGLPolyDataMapper"
  "vtkOpenGLPolyDataMapper2D"
  "vtkOpenGLProperty"
  "vtkOpenGLRenderWindow"
  "vtkOpenGLRenderer"
  "vtkOpenGLRepresentationPainter"
  "vtkOpenGLScalarsToColorsPainter"
  "vtkOpenGLTexture"
  "vtkGLSLShader"
  "vtkGLSLShaderDeviceAdapter"
  "vtkGLSLShaderProgram"
  "vtkOpenGLFreeTypeTextMapper"
  "vtkgl"
  "vtkWin32OpenGLRenderWindow"
  "vtkWin32RenderWindowInteractor")

# Abstract classes in vtkRendering.
SET(VTK_RENDERING_CLASSES_ABSTRACT
  "vtkAbstractMapper3D"
  "vtkAbstractPicker"
  "vtkAbstractPropPicker"
  "vtkAbstractVolumeMapper"
  "vtkCuller"
  "vtkExporter"
  "vtkImporter"
  "vtkInteractorObserver"
  "vtkMapper"
  "vtkPainter"
  "vtkPolyDataPainter"
  "vtkPrimitivePainter"
  "vtkProp3D"
  "vtkShader"
  "vtkShaderDeviceAdapter"
  "vtkShaderProgram"
  "vtkVisibilitySort"
  "vtkOpenGLRenderWindow"
  "vtkgl")

# Wrap-exclude classes in vtkRendering.
SET(VTK_RENDERING_CLASSES_WRAP_EXCLUDE
  "vtkFreeTypeUtilities"
  "vtkgl")

# Set convenient variables to test each class.
FOREACH(class ${VTK_RENDERING_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_RENDERING_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_RENDERING_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
