#include <windows.h>
#include <winnt.h>

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>
#include <TkInt.h>
#include <TkWinInt.h>

#include <Scintilla.h>
#include <SciLexer.h>

#define DEFAULT_WIDTH			"400"
#define DEFAULT_HEIGHT			"400"

typedef struct _TkScintilla { 
	Display *display;
	Tk_Window tkwin;
	Tcl_Interp *interp;
	HWND hWnd;

	int width;
	int height;

	char *marginClickedCommand;
	char *charAddedCommand;
	char *keyCommand;
	char *styleNeededCommand;

    struct _TkScintilla *nextPtr;
} _TkScintilla;

static _TkScintilla* firstPtr = NULL;

void TkScintillaSendVirtualEvent(Tk_Window tkwin, const char *eventName);
int TkScintillaEventFrameCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
int TkScintillaCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
int TkScintillaInstanceCmd( ClientData clientData, Tcl_Interp *interp, int argc, char **argv);
static void TkScintillaEventProc(ClientData clientData, XEvent *eventPtr);
static void TkScintillaCmdDeletedProc( ClientData );

static Tk_ConfigSpec configSpecs[] = 
{
	{TK_CONFIG_PIXELS, "-height", "height", "Height",
		DEFAULT_HEIGHT, Tk_Offset(_TkScintilla, height), 0, NULL},

	{TK_CONFIG_PIXELS, "-width", "width", "Width",
		DEFAULT_WIDTH, Tk_Offset(_TkScintilla, width), 0, NULL},
	
	{TK_CONFIG_STRING, "-marginclickedcommand", "marginClickedCommand", "MarginClickedCommand",
		DEFAULT_WIDTH, Tk_Offset(_TkScintilla, marginClickedCommand), 0, NULL},
	
    {TK_CONFIG_STRING, "-charaddedcommand", "charAddedCommand", "CharAddedCommand",
		DEFAULT_WIDTH, Tk_Offset(_TkScintilla, charAddedCommand), 0, NULL},
    
    {TK_CONFIG_STRING, "-keycommand", "keyCommand", "KeyCommand",
		DEFAULT_WIDTH, Tk_Offset(_TkScintilla, keyCommand), 0, NULL},
    
    {TK_CONFIG_STRING, "-styleneededcommand", "styleNeededCommand", "StyleNeededCommand",
		DEFAULT_WIDTH, Tk_Offset(_TkScintilla, styleNeededCommand), 0, NULL},
    
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
		(char *) NULL, 0, 0, NULL}
};
