#include "tkscintilla.h"

// Reference: 
// http://wiki.tcl.tk/15946
// C:\msys\1.0\works\src\tcl\tk8.5.8\generic\ttk\ttkWidget.c
// C:\msys\1.0\works\src\tcl\tk8.5.8\generic\ttk

BOOL OnNotify ( HWND hWnd, int msg, long wp, long lp, long *pResult )
{
	NMHDR *phDR;
	phDR = (NMHDR*)lp;
    TkWindow *winPtr;
	
	//winPtr = Tk_HWNDToWindow(hWnd);

    _TkScintilla *ptr = NULL;
	for (ptr = firstPtr; ptr != NULL;
		ptr = ptr->nextPtr) {
		if ( ptr->hWnd == hWnd ) break;
	}

	if (phDR != NULL) 
	{
		struct SCNotification *pMsg = (struct SCNotification*)lp;

		// http://cpansearch.perl.org/src/ROBERTMAY/Win32-GUI-1.06/Win32-GUI-Scintilla/Scintilla.xs
		// http://www.scintilla.org/ScintillaDoc.html#SCN_KEY
		
		if ( phDR->code == SCN_PAINTED ) return;

		switch (phDR->code) {
			case SCN_KEY:
				if ( ptr->keyCommand != NULL )
				{
					char cmd[1024];
					// command path position key
					sprintf(cmd, "%s %s %d %d", 
							ptr->keyCommand, 
							Tk_PathName(ptr->tkwin),
							pMsg->ch, 
							pMsg->modifiers);
					if ( Tcl_Eval(ptr->interp, cmd) == TCL_ERROR )
					{
						Tcl_SetResult (ptr->interp, 
								"Error in keycommand", TCL_STATIC);
						return TCL_ERROR;
					}
				}
				break;
			
			case SCN_MARGINCLICK:
				if ( ptr->marginClickedCommand != NULL )
				{
					char cmd[1024];
					sprintf(cmd, "%s %s %d %d", ptr->marginClickedCommand, 
							Tk_PathName(ptr->tkwin),
							pMsg->margin, pMsg->position);
					if ( Tcl_Eval(ptr->interp, cmd) == TCL_ERROR )
					{
						Tcl_SetResult (ptr->interp, 
								"Error in marginclickedcommand", TCL_STATIC);
						return TCL_ERROR;
					}
				}
				break;

			case SCN_UPDATEUI:
				TkScintillaSendVirtualEvent((Tk_Window)ptr->tkwin, "UpdateUI");
				break;
			
			case SCN_CALLTIPCLICK:
			case SCN_STYLENEEDED:
				if ( ptr->styleNeededCommand != NULL )
				{
					char cmd[1024];
					sprintf(cmd, "%s %s %d", ptr->styleNeededCommand, 
							Tk_PathName(ptr->tkwin),
							pMsg->position);
					if ( Tcl_Eval(ptr->interp, cmd) == TCL_ERROR )
					{
						Tcl_SetResult (ptr->interp, 
								"Error in styleneededcommand", TCL_STATIC);
						return TCL_ERROR;
					}
				}
				break;
			
			case SCN_CHARADDED:
				if ( ptr->charAddedCommand != NULL )
				{
					char cmd[1024];
					sprintf(cmd, "%s %s %d", ptr->charAddedCommand, 
							Tk_PathName(ptr->tkwin),
							pMsg->ch);
					if ( Tcl_Eval(ptr->interp, cmd) == TCL_ERROR )
					{
						Tcl_SetResult (ptr->interp, 
								"Error in charaddedcommand", TCL_STATIC);
						return TCL_ERROR;
					}
				}
				break;
			
			case SCN_HOTSPOTCLICK:
			case SCN_PAINTED:
			case SCN_SAVEPOINTREACHED:
			case SCN_SAVEPOINTLEFT:
			case SCN_MODIFYATTEMPTRO:
			case SCN_DOUBLECLICK:
			case SCN_HOTSPOTDOUBLECLICK:
				break;

			default:
				//printf("default...\n"); fflush(stdout);
				break;
		}
	}

	return TRUE;
}

long WinProc (HWND hWnd, int msg, long wp, long lp)
{
	long result;
	
	// Getting scintilla window handle
	HWND hScintillaWnd = GetWindow(hWnd, GW_CHILD);

	//printf("%d\n", msg); fflush(stdout);
	
	switch ( msg ) 
	{
		case WM_KEYDOWN:
		case WM_KEYUP:
			printf("key down...\n"); fflush(stdout);
			return 0;

		case WM_WINDOWPOSCHANGED:
		case WM_MOVE:            
			break;
		
		case WM_SIZE:
			break;

		case BN_CLICKED:
			printf("button down...\n"); fflush(stdout);
			return 0;

		case WM_NOTIFY:
			OnNotify ( hScintillaWnd, msg, wp, lp, NULL );
			break;

		default:
			if (Tk_TranslateWinEvent(hWnd, msg, wp, lp, &result)) {
				return result;
			}
	}

	//return TkWinChildProc (hWnd, msg, wp, lp);	        

	result = DefWindowProc(hWnd, msg, wp, lp);
	Tcl_ServiceAll();

	return result;    
}

int TkScintillaEventFrame_MakeWindowExist(_TkScintilla *ptr)
{
	TkWindow *winPtr;
	TkWindow *winPtr2;
	Display *dpy;
	Tcl_HashEntry *hPtr;
	
	int newFlag;
	static int initialized = 0;

	Window parent;
	Tk_Window tkwin;

	HWND hWnd, hParentWnd;
	HANDLE hInstance;

	winPtr = (TkWindow *) ptr->tkwin;
   
	dpy = Tk_Display(ptr->tkwin);
	
	if (winPtr->window != None) 
	{
		XDestroyWindow(dpy, winPtr->window);
		winPtr->window = 0;
	}
	
	/* Find parent of window */
	/* Necessary for creation */
	if ((winPtr->parentPtr == NULL) || (winPtr->flags & TK_TOP_LEVEL)) 
	{
		parent = XRootWindow(winPtr->display, winPtr->screenNum);
	}
	else 
	{
		if (winPtr->parentPtr->window == None) 
			Tk_MakeWindowExist((Tk_Window) winPtr->parentPtr);
		parent = winPtr->parentPtr->window;
	}

	hParentWnd = Tk_GetHWND(parent);
	hInstance = Tk_GetHINSTANCE();

	if ( !initialized  )
	{
		WNDCLASS class;
		class.style = CS_HREDRAW | CS_VREDRAW;
		class.cbClsExtra = 0;
		class.cbWndExtra = sizeof(long);
		class.hInstance = hInstance;
		class.hbrBackground = NULL;
		class.lpszMenuName = NULL;
		class.lpszClassName = "TkScintillaEventFrame";
		class.lpfnWndProc = WinProc;
		class.hIcon = NULL;
		class.hCursor = NULL;

		if (!RegisterClass(&class))
		{
			Tcl_SetResult (ptr->interp, 
					"Unable to register TkScintilla window class.", 
					TCL_STATIC);
			return TCL_ERROR;
		}

		initialized = 1;
	}

	hWnd = CreateWindow("TkScintillaEventFrame", NULL,
		WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		0, 0, 100, 100,
		hParentWnd, NULL, hInstance, NULL);

	ptr->hWnd = hWnd;
	
	winPtr->window = Tk_AttachHWND((Tk_Window)winPtr, hWnd);

	hPtr = Tcl_CreateHashEntry(&winPtr->dispPtr->winTable,
		(char *) winPtr->window, &newFlag);
	Tcl_SetHashValue(hPtr, winPtr);
	
	Tk_MapWindow ( ptr->tkwin );
	XMapWindow(dpy, Tk_WindowId(ptr->tkwin));

	return TCL_OK;
}

void Register(HINSTANCE hInstance) 
{
	const char resourceName[] = "SciTE";

	WNDCLASS wndclass;

	// Register the frame window
	wndclass.style = 0;
	wndclass.lpfnWndProc = WinProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = sizeof(long);
	wndclass.hInstance = hInstance;
	wndclass.hIcon = LoadIcon(hInstance, resourceName);
	wndclass.hCursor = NULL;
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName = resourceName;
	wndclass.lpszClassName = "SciTEWindow";
	if (!RegisterClass(&wndclass))
		exit(FALSE);

	wndclass.lpfnWndProc = WinProc;
	wndclass.lpszMenuName = 0;
	wndclass.lpszClassName = "SciTEWindowContent";
	if (!RegisterClass(&wndclass))
		exit(FALSE);
}

int TkScintilla_MakeWindowExist(_TkScintilla *ptr)
{
	TkWindow *winPtr;
	TkWindow *winPtr2;
	Display *dpy;
	Tcl_HashEntry *hPtr;
	static int initialized = 0;
	
	int newFlag;

	Window parent;
	Tk_Window tkwin;

	HWND hWnd, hParentWnd;
	HANDLE hInstance;

	winPtr = (TkWindow *) ptr->tkwin;
   
	dpy = Tk_Display(ptr->tkwin);
	
	if (winPtr->window != None) 
	{
		XDestroyWindow(dpy, winPtr->window);
		winPtr->window = 0;
	}
	
	/* Find parent of window */
	/* Necessary for creation */
	if ((winPtr->parentPtr == NULL) || (winPtr->flags & TK_TOP_LEVEL)) 
	{
		parent = XRootWindow(winPtr->display, winPtr->screenNum);
	}
	else 
	{
		if (winPtr->parentPtr->window == None) 
			Tk_MakeWindowExist((Tk_Window) winPtr->parentPtr);
		parent = winPtr->parentPtr->window;
	}

	hParentWnd = Tk_GetHWND(parent);
	hInstance = Tk_GetHINSTANCE();
		
	// ------------
	if ( LoadLibrary("SciLexer.dll") == NULL ) 
	{
		Tcl_SetResult (ptr->interp, 
				"The Scintilla DLL could not be loaded.", TCL_STATIC);
		return TCL_ERROR;
	}

	hWnd = CreateWindow("Scintilla", NULL,
		WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		0, 0, 100, 100,
		hParentWnd, NULL, hInstance, NULL);

	ptr->hWnd = hWnd;
	
	winPtr->window = Tk_AttachHWND((Tk_Window)winPtr, hWnd);

	hPtr = Tcl_CreateHashEntry(&winPtr->dispPtr->winTable,
		(char *) winPtr->window, &newFlag);
	Tcl_SetHashValue(hPtr, winPtr);

	Tk_MapWindow ( ptr->tkwin );
	XMapWindow(dpy, Tk_WindowId(ptr->tkwin));
	
	return TCL_OK;
}

int TkScintillaInstanceCmd(
	ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
	_TkScintilla *ptr = (_TkScintilla *) clientData;

	if (argc < 2) {
		Tcl_AppendResult(interp, "wrong # args: should be \"", 
				argv[0], " ?options?\"", NULL);
		return TCL_ERROR;
	}

	Tk_Preserve((ClientData)ptr);

	if( !strcmp(argv[1], "configure") ) 
	{
		Tk_ConfigureInfo(interp, ptr->tkwin, configSpecs,
			(char *)ptr, (char *)NULL, 0);
	}
	else if( !strcmp(argv[1], "GetHandle") ) 
	{
		Tcl_SetObjResult(interp, Tcl_NewIntObj(ptr->hWnd));
		return TCL_OK;
	} 

	Tk_Release((ClientData)ptr);
}

int TkScintillaEventFrameCmd(
	ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
	_TkScintilla *ptr;
	Tk_Window tkwin;

	if (argc < 2) 
	{
		Tcl_AppendResult(interp, "wrong # args:  should be \"",
			argv[0], " pathName ?options?\"", (char *) NULL);
		return TCL_ERROR;
	}

	// Tk window 
	tkwin = Tk_CreateWindowFromPath(interp, 
			Tk_MainWindow(interp), argv[1], (char *) NULL);
	if (tkwin == NULL) {
		return TCL_ERROR;
	}

	Tk_SetClass(tkwin, "TkScintillaEventFrame");

	ptr = (_TkScintilla *) Tcl_Alloc(sizeof(_TkScintilla));
	ptr->display = Tk_Display( tkwin );
	ptr->tkwin = tkwin;
	ptr->interp = interp;
	ptr->width = 100;
	ptr->height = 100;
	ptr->hWnd = NULL;

	if (TkScintillaConfigure(interp, 
				ptr, argc-2, argv+2, 0) != TCL_OK) 
	{
		Tk_DestroyWindow(tkwin);
		return TCL_ERROR;
	}

	if (TkScintillaEventFrame_MakeWindowExist(ptr) != TCL_OK) 
	{
		Tcl_AppendResult(interp, "Could not make window exist", (char *) NULL);
		return TCL_ERROR;
	}

	Tcl_AppendResult(interp, Tk_PathName(tkwin), NULL);

	return TCL_OK;
}

int TkScintillaCmd(
	ClientData clientData, Tcl_Interp *interp, int argc, char **argv)
{
	_TkScintilla *ptr;
	Tk_Window tkwin;

	if (argc < 2) 
	{
		Tcl_AppendResult(interp, "wrong # args:  should be \"",
			argv[0], " pathName ?options?\"", (char *) NULL);
		return TCL_ERROR;
	}

	// Tk window 
	tkwin = Tk_CreateWindowFromPath(interp, 
			Tk_MainWindow(interp), argv[1], (char *) NULL);
	if (tkwin == NULL) {
		return TCL_ERROR;
	}

	Tk_SetClass(tkwin, "TkScintilla");

	ptr = (_TkScintilla *) Tcl_Alloc(sizeof(_TkScintilla));
	ptr->display = Tk_Display( tkwin );
	ptr->tkwin = tkwin;
	ptr->interp = interp;
	ptr->width = 100;
	ptr->height = 100;
	ptr->hWnd = NULL;
	ptr->marginClickedCommand = NULL;
	ptr->charAddedCommand = NULL;
	ptr->keyCommand = NULL;
	ptr->styleNeededCommand = NULL;
    ptr->nextPtr = firstPtr;

    firstPtr = ptr;
	
	
	/*
	Tk_CreateEventHandler( tkwin, 
		ExposureMask | StructureNotifyMask | FocusChangeMask | 
		VirtualEventMask | ActivateMask |
		ButtonPressMask|ButtonReleaseMask |
		EnterWindowMask | LeaveWindowMask |
		KeyPressMask|KeyReleaseMask |ButtonPressMask|
		ButtonReleaseMask|EnterWindowMask |
		LeaveWindowMask|PointerMotionMask,
		TkScintillaEventProc, (ClientData)ptr);
	*/

	Tcl_CreateCommand(interp, Tk_PathName(tkwin), 
			(Tcl_CmdProc *) TkScintillaInstanceCmd,
			(ClientData)ptr, (void (*)(int *))NULL);
 	
	if (TkScintillaConfigure(interp, 
				ptr, argc-2, argv+2, 0) != TCL_OK) 
	{
		Tk_DestroyWindow(tkwin);
		return TCL_ERROR;
	}

	if (TkScintilla_MakeWindowExist(ptr) != TCL_OK) 
	{
		Tcl_AppendResult(interp, "Could not make window exist", (char *) NULL);
		return TCL_ERROR;
	}

	Tcl_AppendResult(interp, Tk_PathName(tkwin), NULL);

	//Tk_CreateTimerHandler(10, (Tk_TimerProc*)Timer,NULL);

	return TCL_OK;
}

void TkScintillaSendVirtualEvent(Tk_Window tkwin, const char *eventName)
{
    XEvent event;

    memset(&event, 0, sizeof(event));
    event.xany.type = VirtualEvent;
    event.xany.serial = NextRequest(Tk_Display(tkwin));
    event.xany.send_event = False;
    event.xany.window = Tk_WindowId(tkwin);
    event.xany.display = Tk_Display(tkwin);
    ((XVirtualEvent *) &event)->name = Tk_GetUid(eventName);

    Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
}

char *tksci_GetTextRange(int hWnd, int startPos, int endPos)
{
	 if (endPos < startPos) {
		 int temp = startPos;
		 startPos = endPos;
		 endPos = temp;
	 }

	 int   len  = endPos - startPos;
	 if (!len) return "";
	 char *buf = (char *)malloc(len);
	 struct TextRange tr;
	 tr.lpstrText = buf;
	 tr.chrg.cpMin = startPos;
	 tr.chrg.cpMax = endPos;
	 SendMessage(hWnd, SCI_GETTEXTRANGE, 0, (long)&tr);
	 return buf;
}

static void TkScintillaEventProc(ClientData clientData, XEvent *eventPtr)
{
	_TkScintilla *ptr = (_TkScintilla *) clientData;
	
	switch (eventPtr->type) 
	{
		case MotionNotify:
			printf("PointerMotionMask\n"); fflush(stdout);
			Tk_ResizeWindow (ptr->tkwin, ptr->width, ptr->height);
			break;

		case Expose:
			printf("Expose\n"); fflush(stdout);
			Tk_ResizeWindow (ptr->tkwin, ptr->width, ptr->height);
			break;

		case ConfigureNotify:
			//printf("ConfigureNotify\n"); fflush(stdout);
			if (ptr->width != Tk_Width(ptr->tkwin) ||
				ptr->height != Tk_Height(ptr->tkwin)) 
			{
				ptr->width = Tk_Width(ptr->tkwin);
				ptr->height = Tk_Height(ptr->tkwin);
				XResizeWindow(Tk_Display(ptr->tkwin), Tk_WindowId(ptr->tkwin),
					ptr->width, ptr->height);
			}
			break;

		case MapNotify:
			printf("MapNotify\n"); fflush(stdout);
			break;

		case DestroyNotify:
			printf("DestroyNotify\n"); fflush(stdout);
			break;

		case FocusIn:
		case FocusOut:
			printf("Focus\n"); fflush(stdout);
			break;

		case ActivateNotify:
			printf("ActivateNotify\n"); fflush(stdout);
			break;

		case DeactivateNotify:
			printf("DeactivateNotify\n"); fflush(stdout);
			break;

		case LeaveNotify:
			printf("LeaveNotify\n"); fflush(stdout);
			break;

		case EnterNotify:
			printf("EnterNotify\n"); fflush(stdout);
			break;

		case VirtualEvent:
			printf("VirtualEvent\n"); fflush(stdout);
			break;

		case ButtonPress:
			printf("ButtonPress\n"); fflush(stdout);
			break;

		case ButtonRelease:
			printf("ButtonRelease\n"); fflush(stdout);
			break;
		
		case KeyPress:
			printf("KeyPress\n"); fflush(stdout);
			break;

		default:
			printf("DefaultEvent\n"); fflush(stdout);
			break;
	}
}

int TkScintillaConfigure(Tcl_Interp *interp, _TkScintilla *ptr,
                   int argc, char *argv[], int flags)
{
	if (Tk_ConfigureWidget(interp, ptr->tkwin, configSpecs,
		argc, argv, (char *)ptr, flags) == TCL_ERROR) 
	{
		return TCL_ERROR;
	}

	Tk_GeometryRequest(ptr->tkwin, ptr->width, ptr->height);

	return TCL_OK;
}
