.\" tdbc_resultset.n --
.\"
.\" Copyright (c) 2008 by Kevin B. Kenny.
.\"
.\" See the file "license.terms" for information on usage and redistribution of
.\" this file, and for a DISCLAIMER OF ALL WARRANTIES.
.\"
.\" .so man.macros
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.TH "tdbc::resultset" n 8.6 Tcl "Tcl Database Connectivity"
.BS
.SH "NAME"
tdbc::resultset \- TDBC result set object
.SH "SYNOPSIS"
package require \fBtdbc 1.0\fR
.sp
package require \fBtdbc::\fR\fIdriver version\fR
.sp
\fBtdbc::\fR\fIdriver\fR\fB::connection create \fR\fIdb\fR \fI?\-option value\fR...?
.sp
\fBset\fR \fIstmt\fR \fB[\fR\fIdb\fR \fBprepare\fR \fIsql-code\fR\fB]\fR
.sp
\fBset\fR \fIresultset\fR \fB[\fR\fI$stmt\fR \fBexecute\fR ?\fIargs...\fR?
.sp
\fI$resultset\fR \fBcolumns\fR
.sp
\fI$resultset \fR \fBrowcount\fR
.sp
\fI$resultset\fR \fBnextrow\fR ?\fB-as\fR \fBlists\fR|\fBdicts\fR? ?\fB--\fR? \fIvarname\fR
.sp
\fI$resultset\fR \fBnextlist\fR \fIvarname\fR
.sp
\fI$resultset\fR \fBnextdict\fR \fIvarname\fR
.sp
\fI$resultset\fR \fBallrows\fR ?\fB-as lists|dicts\fR? ?\fB-columnsvariable\fR \fIname\fR? ?\fB--\fR?
.sp
\fI$resultset\fR \fBforeach\fR ?\fB-as lists|dicts\fR?
?\fB-columnsvariable\fR \fIname\fR? ?\fB--\fR? \fIvarname\fR \fIscript\fR
.sp
\fI$resultset\fR \fBclose\fR
.BE
.SH "DESCRIPTION"
.PP
Every database driver for TDBC (Tcl DataBase Connectivity) implements
a \fIresult set\fR object that represents a the results returned from
executing SQL statement in a database. Instances of this object are created 
by executing the \fBexecute\fR object command on a statement object.
.PP
The \fBcolumns\fR obect command returns a list of the names of the columns 
in the result set. The columns will appear in the same order as they appeared
in the SQL statement that performed the database query. If the SQL statement
does not return a set of columns (for instance, if it is an INSERT,
UPDATE, or DELETE statement), the \fBcolumns\fR command will return an empty
list.
.PP
The \fBrowcount\fR object command returns the number of rows in the database
that were affected by the execution of an INSERT, UPDATE or DELETE statement.
For a SELECT statement, the row count is unspecified.
.PP
The \fBnextlist\fR object command sets the variable given by \fIvarname\fR 
in the caller's scope to the next row of the results, expressed as a list 
of column values. NULL values are replaced by empty strings. The
columns of the result row appear in the same order in which they
appeared on the SELECT statement. The
return of \fBnextlist\fR is \fB1\fR if the operation succeeded, and
\fB0\fR  if the end of the result set was reached.
.PP
The \fBnextdict\fR object command sets the variable given by \fIvarname\fR 
in the caller's scope to the next row of the results, expressed as a
dictionary. The dictionary's keys are column names, and the values are
the values of those columns in the row. If a column's value in the row
is NULL, its key is omitted from the dictionary.
The keys appear in the dictionary in the same order in which the
columns appeared on the SELECT statement. The
return of \fBnextdict\fR is \fB1\fR if the operation succeeded, and
\fB0\fR  if the end of the result set was reached.
.PP
The \fBnextrow\fR object command is precisely equivalent to the
\fBnextdict\fR or \fBnextlist\fR object command, depending on whether
\fB-as dicts\fR (the default) or \fB-as lists\fR is specified. 
.PP
The \fBallrows\fR object command sets the variable designated by the
\fB-columnsvariable\fR option (if present) to the result of the \fBcolumns\fR
object command. It then executes the \fBnextrow\fR object command
repeatedly until the end of the result set is reached. The resulting
rows are assembled into a Tcl list and become the return value of the
\fBallrows\fR command.
.PP
The \fBforeach\fR object command sets the variable designated by the
\fB-columnsvariable\fR option (if present) to the result of the \fBcolumns\fR
object command. It then executes the \fBnextrow\fR object command
repeatedly until the end of the result set is reached, storing the
successive rows in the variable designated by \fIvarName\fR. For each
row, it executes the given \fIscript\fR. If the script terminates with
an error, the error is reported by the \fBforeach\fR command, and
iteration stops. If the script performs a \fBbreak\fR operation, the
iteration terminates prematurely. If the script performs a
\fBcontinue\fR operation, the iteration recommences with the next row.
If the script performs a \fBreturn\fR, results are the same as if a
script outside the control of \fBforeach\fR had returned. Any other
unusual return code terminates the iteration and is reported from the
\fBforeach\fR. 
.PP
The \fBclose\fR object command deletes the result set and frees any
associated system resources.
.SH "SEE ALSO"
encoding(n), tdbc(n), tdbc_connection(n), tdbc_statement(n),  tdbc_tokenize(n)
.SH "KEYWORDS"
TDBC, SQL, database, connectivity, connection, resultset, statement,
bound variable, stored procedure, call
.SH "COPYRIGHT"
Copyright (c) 2008 by Kevin B. Kenny.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\"
