load ../../tclsdl.dll

# ------------------------------
set DIM_H 800
set DIM_V 600

set BG_H 400
set BG_W 2000

set SCROLLING_MAX 4
set PIXEL_X_MS 0.15

set DIST_SCROLL 40

# ------------------------------
SDL_Init $SDL_INIT_VIDEO
set flags [expr $SDL_HWSURFACE|$SDL_DOUBLEBUF]
set screen [SDL_SetVideoMode $DIM_H $DIM_V 0 $flags]
SDL_WM_SetCaption "SDL Mouse Scrolling Example" ""

SDL_ShowCursor 0

set temp [IMG_Load "m_pointer.png"]
if { $temp == "NULL" } {
	puts "SDL error: [SDL_GetError]"
	exit 1
}
set cursor [SDL_DisplayFormat $temp]
SDL_FreeSurface $temp

set format [SDL_Surface_format_get $cursor]
set rgb [SDL_MapRGB $format 255 0 255]
SDL_SetColorKey $cursor [expr $SDL_SRCCOLORKEY|$SDL_RLEACCEL] $rgb

set temp [IMG_Load "bg.jpg"]
if { $temp == "NULL" } {
	puts "SDL error: [SDL_GetError]"
	exit 1
}
set bg [SDL_DisplayFormat $temp]
SDL_FreeSurface $temp

set bg_rect [new_SDL_Rect]
set dest_rect [new_SDL_Rect]

SDL_Rect_x_set $bg_rect 0
SDL_Rect_y_set $bg_rect 0
SDL_Rect_w_set $bg_rect [expr $DIM_H-1]
SDL_Rect_h_set $bg_rect $BG_H

SDL_Rect_x_set $dest_rect 0
SDL_Rect_y_set $dest_rect 100
SDL_Rect_w_set $dest_rect [expr $DIM_H-1]
SDL_Rect_h_set $dest_rect $BG_H

set done 0

set event [SDL_Event]

set rect_cur [new_SDL_Rect]
SDL_Rect_x_set $rect_cur 0
SDL_Rect_y_set $rect_cur 0
SDL_Rect_w_set $rect_cur [SDL_Surface_w_get $cursor]
SDL_Rect_h_set $rect_cur [SDL_Surface_h_get $cursor]

set numFrames 0

set t1 [SDL_GetTicks]
set t_start $t1

while { !$done } {
	set numFrames [expr $numFrames+1]

	set t2 [SDL_GetTicks]
	set dt [expr $t2-$t1]
	set t1 $t2

	while { [SDL_PollEvent $event] } {
		set event_type [SDL_Event_type_get $event] 
		if { $event_type == "$SDL_KEYDOWN" } {
			set key_event [SDL_Event_key_get $event]
			set keysym_event [SDL_KeyboardEvent_keysym_get $key_event]
			set key_name [SDL_GetKeyName [SDL_keysym_sym_get $keysym_event]]

			if { $key_name == "escape" } { set done 1 }

		} elseif { $event_type == "$SDL_MOUSEMOTION" } {
			set motion_event [SDL_Event_motion_get $event]
			set x [SDL_MouseMotionEvent_x_get $motion_event]
			set y [SDL_MouseMotionEvent_y_get $motion_event]
			set w [SDL_Surface_w_get $cursor]
			set h [SDL_Surface_h_get $cursor]

			SDL_Rect_x_set $rect_cur $x
			SDL_Rect_y_set $rect_cur $y
			SDL_Rect_w_set $rect_cur $w
			SDL_Rect_h_set $rect_cur $h
		}

		set rect_cur_x [SDL_Rect_x_get $rect_cur]
		set bg_rect_x [SDL_Rect_x_get $bg_rect]

		if { [expr $DIM_H-$rect_cur_x] < $DIST_SCROLL & \
			[expr $bg_rect_x+$SCROLLING_MAX] < [expr $BG_W-$DIM_H] } {
			set bg_rect_x [expr $bg_rect_x + [expr int(ceil($PIXEL_X_MS * $dt))]]
			SDL_Rect_x_set $bg_rect $bg_rect_x
		}
		
		if { $rect_cur_x < $DIST_SCROLL & [expr $bg_rect_x-$SCROLLING_MAX] > 0 } {
			set bg_rect_x [expr $bg_rect_x - [expr int(ceil($PIXEL_X_MS * $dt))]]
			SDL_Rect_x_set $bg_rect $bg_rect_x
		}
		
		SDL_UpperBlit $bg $bg_rect $screen $dest_rect
		SDL_UpperBlit $cursor NULL $screen $rect_cur

		set w [SDL_Rect_w_get $bg_rect]
		set h [SDL_Rect_h_get $bg_rect]
		SDL_UpdateRect $screen 0 100 $w $h
	}

	set t_end [SDL_GetTicks]
}
