#ifndef SPRITE_H
#define SPRITE_H

#include <SDL/SDL.h>
#include "gamestate.h"

#define S_RIGHTSTAND 0
#define S_LEFTSTAND 1
#define S_RIGHTWALK 2
#define S_LEFTWALK 3

class Sprite
{
  SDL_Surface* sheet;
  int px, py;
  int action; // rightStand = 0, leftStand = 1, rightWalking = 2, leftWalking = 3
  int frame;
  SDL_Rect bb;

public:
	Sprite();
	~Sprite();

  SDL_Rect& getBoundingBox(void);
	void stand(void);
	void updateFrame(void);
	void walkLeft(void);
  void walkRight(void);
  void draw(void);
};

#endif
