#include <SDL/SDL.h>
#include "gameengine.h"
#include "gamestate.h"
#include "introstate.h"
#include "playstate.h"

CIntroState introState;
extern CPlayState playState;

void CIntroState::Init()
{
	bg = SDL_LoadBMP("intro.bmp");
}

void CIntroState::Cleanup()
{
	SDL_FreeSurface(bg);
}

void CIntroState::Pause()
{
}

void CIntroState::Resume()
{
}

void CIntroState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;

			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
					case SDLK_SPACE:
						game->ChangeState( &playState );
						break;
					case SDLK_ESCAPE:
						game->Quit();
						break;
				}
				break;
		}
	}
}

void CIntroState::Update(CGameEngine* game)
{
}

void CIntroState::Draw(CGameEngine* game)
{
	SDL_BlitSurface(bg, NULL, game->screen, NULL);
}
