#include <SDL/SDL.h>
#include "gameengine.h"
#include "gamestate.h"
#include "introstate.h"
#include "playstate.h"
#include "ball.h"


Ball::Ball()
{
  SDL_Surface* temp = SDL_LoadBMP("ball.bmp");
  image = SDL_DisplayFormat(temp);
  SDL_FreeSurface(temp);

  Uint32 colorkey = SDL_MapRGB(image->format, 255, 0, 0);
  SDL_SetColorKey(image, SDL_RLEACCEL | SDL_SRCCOLORKEY, colorkey);

  dir = 1; // initially moving to right

  px = 0;
  py = 272 / 2;

}

Ball::~Ball()
{
  SDL_FreeSurface(image);
}

void Ball::updateFrame(void)
{
}

void Ball::changeDirection(void)
{
}

SDL_Rect& Ball::getBoundingBox(void)
{
}

void Ball::draw(void)
{
  SDL_Surface* screen = SDL_GetVideoSurface();

  SDL_Rect rect;
  rect.x = px;
  rect.y = py;

  SDL_BlitSurface(image, NULL, screen, &rect);
}
