#include <SDL/SDL.h>
#include "gameengine.h"
#include "gamestate.h"
#include "introstate.h"
#include "playstate.h"
#include "sprite.h"


Sprite::Sprite()
{
  SDL_Surface* temp = SDL_LoadBMP("spritesheet.bmp");
  sheet = SDL_DisplayFormat(temp);
  SDL_FreeSurface(temp);

  Uint32 colorkey = SDL_MapRGB(sheet->format, 255, 0, 0);
  SDL_SetColorKey(sheet, SDL_RLEACCEL | SDL_SRCCOLORKEY, colorkey);

  action = S_RIGHTSTAND;
  frame = 0;

  px = 480 / 2 - 50;
  py = 272 / 2;
}

Sprite::~Sprite()
{
  SDL_FreeSurface(sheet);
}

void Sprite::stand(void)
{
  if (action == S_RIGHTWALK) {
    action = S_RIGHTSTAND;
    frame = 0;
  } else if (action == S_LEFTWALK) {
    action = S_LEFTSTAND;
    frame = 0;
  }
}

void Sprite::walkRight(void)
{
  if (action != S_RIGHTWALK) {
    action = S_RIGHTWALK;
    frame = 0;
  }
  px += 4;
}

void Sprite::walkLeft(void)
{
  if (action != S_LEFTWALK) {
    action = S_LEFTWALK;
    frame = 0;
  }
  px -= 4;
}

void Sprite::updateFrame(void)
{
  frame = (frame + 1) % 8;
}


void Sprite::draw(void)
{
  SDL_Surface* screen = SDL_GetVideoSurface();

  SDL_Rect sheetRect, playerRect;
  sheetRect.x = frame * 100;
  sheetRect.y = action * 100;
  sheetRect.w = 100;
  sheetRect.h = 100;
  playerRect.x = px;
  playerRect.y = py;

  SDL_BlitSurface(sheet, &sheetRect, screen, &playerRect);
}
