#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>
#include "gameengine.h"
#include "gamestate.h"

TTF_Font *font;

void CGameEngine::Init(const char* title, int width, int height,
						 int bpp, bool fullscreen)
{
  int flags = 0;
  SDL_Init(SDL_INIT_EVERYTHING);

  if ( fullscreen ) {
    flags = SDL_FULLSCREEN;
  }
  screen = SDL_SetVideoMode(width, height, bpp, flags);

  m_fullscreen = fullscreen;
  m_running = true;

  TTF_Init();
  font = TTF_OpenFont("HYNAMB.ttf", 20);


}

void CGameEngine::Cleanup()
{
	while ( !states.empty() ) {
		states.back()->Cleanup();
		states.pop_back();
	}

	// switch back to windowed mode so other
	// programs won't get accidentally resized
	if ( m_fullscreen ) {
		screen = SDL_SetVideoMode(640, 480, 0, 0);
	}

  TTF_CloseFont(font);
  TTF_Quit();
	SDL_Quit();
}

void CGameEngine::ChangeState(CGameState* state)
{
	// cleanup the current state
	if ( !states.empty() ) {
		states.back()->Cleanup();
		states.pop_back();
	}

	// store and init the new state
	states.push_back(state);
	states.back()->Init();
}

void CGameEngine::PushState(CGameState* state)
{
	// pause current state
	if ( !states.empty() ) {
		states.back()->Pause();
	}

	// store and init the new state
	states.push_back(state);
	states.back()->Init();
}

void CGameEngine::PopState()
{
	// cleanup the current state
	if ( !states.empty() ) {
		states.back()->Cleanup();
		states.pop_back();
	}

	// resume previous state
	if ( !states.empty() ) {
		states.back()->Resume();
	}
}

void CGameEngine::HandleEvents()
{
	// let the state handle events
	states.back()->HandleEvents(this);
}

void CGameEngine::Update()
{
	// let the state update the game
	states.back()->Update(this);
}

void CGameEngine::Draw()
{
	states.back()->Draw(this);
}

void CGameEngine::UpdateScreen(void)
{
}

void CGameEngine::RegulateFPS()
{
}

