#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>
#include "gamestate.h"
#include "gameengine.h"
#include "introstate.h"
#include "playstate.h"
#include "sprite.h"

CPlayState playState;
extern CIntroState introState;

SDL_Surface *msg1, *msg2;

void CPlayState::Init()
{
    player = new Sprite;

    SDL_Surface* temp = SDL_LoadBMP("background.bmp");
    bg = SDL_DisplayFormat(temp);
    SDL_FreeSurface(temp);

    SDL_ShowCursor(false);
    SDL_EnableKeyRepeat(10, SDL_DEFAULT_REPEAT_INTERVAL);
}

void CPlayState::Cleanup()
{
  delete player;

  SDL_ShowCursor(false);
}

void CPlayState::Pause()
{
}

void CPlayState::Resume()
{
}

void CPlayState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;
			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
        case SDLK_ESCAPE:
						game->ChangeState( &introState );
						break;
          case SDLK_LEFT:
            player->walkLeft();
            break;
          case SDLK_RIGHT:
            player->walkRight();
            break;
				}
				break;

     case SDL_KEYUP:
      switch (event.key.keysym.sym) {
        case SDLK_LEFT:
        case SDLK_RIGHT:
          player->stand();
          break;
      }
      break;
    }
	}
}

void CPlayState::Update(CGameEngine* game)
{
    player->updateFrame();
}

void CPlayState::Draw(CGameEngine* game)
{
  SDL_BlitSurface(bg, NULL, game->screen, NULL);
  player->draw();

  SDL_Flip(game->screen);
}

