#include <math.h>

#include <SDL/SDL.h>
#include "gamestate.h"
#include "gameengine.h"
#include "introstate.h"
#include "playstate.h"

CPlayState playState;
extern CIntroState introState;

void CPlayState::Init()
{

}

void CPlayState::Cleanup()
{
	SDL_FreeSurface(player);
	SDL_FreeSurface(bg);
    SDL_ShowCursor(false);
}

void CPlayState::Pause()
{
}

void CPlayState::Resume()
{
}

void CPlayState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;

			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
					case SDLK_ESCAPE:
						game->ChangeState( &introState );
						break;
				}
				break;

            case SDL_MOUSEMOTION:
                mx = event.motion.x;
                my = event.motion.y;
                break;
		}
	}
}

void CPlayState::Update(CGameEngine* game)
{
    px = mx + cos(degree) * radius;
    py = my - sin(degree) * radius;
    degree += 0.005f;
    if (degree > 2 * 3.141952)
        degree = 0.0f;
}

void CPlayState::Draw(CGameEngine* game)
{

}

