#include <math.h>


#include <SDL/SDL.h>
#include "gamestate.h"
#include "gameengine.h"
#include "playstate.h"
#include "menustate.h"
#include "itemstate.h"

CPlayState CPlayState::m_PlayState;

void CPlayState::Init()
{
    player = SDL_LoadBMP("character.bmp");
    SDL_Surface* screen = SDL_GetVideoSurface();
    radius = 50;
    degree = 0.0f;
    mx = screen->w / 2;
    my = screen->h / 2;
    px = 0;
    py = 0;
    SDL_WarpMouse(mx, my);
    SDL_ShowCursor(true);
    SDL_FillRect(screen, NULL, 0);
}

void CPlayState::Cleanup()
{
	SDL_FreeSurface(player);
    SDL_ShowCursor(false);
}

void CPlayState::Pause()
{
    SDL_ShowCursor(false);
}

void CPlayState::Resume()
{
    SDL_ShowCursor(true);
    SDL_WarpMouse(mx, my);

    SDL_Surface* screen = SDL_GetVideoSurface();
    SDL_FillRect(screen, NULL, 0);
}

void CPlayState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;

			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
					case SDLK_ESCAPE:
						game->ChangeState( CMenuState::Instance() );
						break;
					case SDLK_i:
						game->PushState( CItemState::Instance() );
						break;
				}
				break;

            case SDL_MOUSEMOTION:
                mx = event.motion.x;
                my = event.motion.y;
                break;
		}
	}
}

void CPlayState::Update(CGameEngine* game)
{
    px = mx + cos(degree) * radius;
    py = my - sin(degree) * radius;
    degree += 0.005f;
    if (degree > 2 * 3.141952)
        degree = 0.0f;
}

void CPlayState::Draw(CGameEngine* game)
{
    SDL_Rect dstrect;
    dstrect.x = px - player->w / 2;
    dstrect.y = py - player->h / 2;

    SDL_BlitSurface(player, 0, game->screen, &dstrect);
    SDL_Flip(game->screen);
}

