#include <SDL/SDL.h>
#include "gameengine.h"
#include "gamestate.h"
#include "introstate.h"
#include "menustate.h"

CMenuState menuState;
extern CIntroState introState;

void CMenuState::Init()
{
	bg = SDL_LoadBMP("menu.bmp");
}

void CMenuState::Cleanup()
{
	SDL_FreeSurface(bg);
}

void CMenuState::Pause()
{
}

void CMenuState::Resume()
{
}

void CMenuState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;
			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
					case SDLK_ESCAPE:
						game->ChangeState(&introState);
						break;
				}
				break;
		}
	}
}

void CMenuState::Update(CGameEngine* game)
{
}

void CMenuState::Draw(CGameEngine* game)
{
	SDL_BlitSurface(bg, NULL, game->screen, NULL);
	SDL_Flip(game->screen);
}
