
#ifndef INTROSTATE_H
#define INTROSTATE_H

#include <SDL/SDL.h>
#include "gamestate.h"

class CItemState : public CGameState
{
public:
	void Init();
	void Cleanup();

	void Pause();
	void Resume();

	void HandleEvents(CGameEngine* game);
	void Update(CGameEngine* game);
	void Draw(CGameEngine* game);

	static CItemState* Instance() {
		return &m_ItemState;
	}

protected:
	CItemState() { }

private:
	static CItemState m_ItemState;

	SDL_Surface* bg;
};

#endif