
#include <stdio.h>

#include <SDL/SDL.h>
#include "gamestate.h"
#include "gameengine.h"
#include "playstate.h"
#include "menustate.h"
#include "itemstate.h"

CItemState CItemState::m_ItemState;

void CItemState::Init()
{
    bg = SDL_LoadBMP("item.bmp");
}

void CItemState::Cleanup()
{
	SDL_FreeSurface(bg);
}

void CItemState::Pause()
{
}

void CItemState::Resume()
{
}

void CItemState::HandleEvents(CGameEngine* game)
{
	SDL_Event event;

	if (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_QUIT:
				game->Quit();
				break;

			case SDL_KEYDOWN:
				switch (event.key.keysym.sym) {
					case SDLK_ESCAPE:
						game->PopState();
						break;
                }
				break;
		}
	}
}

void CItemState::Update(CGameEngine* game)
{
}

void CItemState::Draw(CGameEngine* game)
{
    SDL_BlitSurface(bg, NULL, game->screen, NULL);
	SDL_Flip(game->screen);
}

