/*
 *      File TYPEDEFS.H
 *      Type Definitions
 *      '92.2.5
 *      Written by Lim, I.K.
 */


#ifndef _TYPEDEFS_H_
#define _TYPEDEFS_H_


/** Macro constants ********************************************************/

#ifndef NOERROR
    #define NOERROR 0     /* No error occured      */
    #define ERROR   (-1)  /* Generic error occured */
#endif

#ifndef NULL
    #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
        #define NULL 0
    #else
        #define NULL 0L
    #endif
#endif


/** Type definitions *******************************************************/

typedef enum {false, true} bool;

#ifdef __cplusplus
    typedef char byte;
#else
    typedef unsigned char byte;
#endif

typedef unsigned word;
typedef unsigned long longword;

#ifndef _SIZE_T
    #define _SIZE_T
    typedef unsigned size_t;
#endif

#endif
