/*
 *      File HGCREGS.H
 *      Define Display Interface Ports of HGC
 *      '90.7.16
 *      '91.7.16
 *      Written by Lim, I.K.
 */


#ifndef _HGCREGS_H_
#define _HGCREGS_H_


/** 6845 CRT Controller Registers(total 17) ********************************/

#define CIR 0x03b4  /* 6845 Index Register(Write Only) */
#define CDR 0x03b5  /* 6845 Data Register(Read/Write)  */

#define HTR   0x00  /* R0:  Horizontal Total Register         */
#define HDR   0x01  /* R1:  Horizontal Displayed Register     */
#define HSPR  0x02  /* R2:  Horizontal Sync Position Register */
#define SWR   0x03  /* R3:  Sync Width Register               */
#define VTR   0x04  /* R4:  Vertical Total Register           */
#define VAR   0x05  /* R5:  Vertical Adjust Register          */
#define VDR   0x06  /* R6:  Vertical Displayed Register       */
#define VSPR  0x07  /* R7:  Vertical Sync Position Register   */
#define ISR   0x08  /* R8:  Interlace and Skew Register       */
#define MRAR  0x09  /* R9:  Maximum Raster Address Register   */
#define CSRR  0x0a  /* R10: Cursor Start Raster Register      */
#define CERR  0x0b  /* R11: Cursor End Raster Register        */
#define SARH  0x0c  /* R12: Start Address Register(High)      */
#define SARL  0x0d  /* R13: Start Address Register(Low)       */
#define CPRH  0x0e  /* R14: Cursor Position Register(High)    */
#define CPRL  0x0f  /* R15: Cursor Position Register(Low)     */
#define LPPRH 0x10  /* R16: Light Pen Position Register(High) */
#define LPPRL 0x11  /* R17: Light Pen Position Register(Low)  */


/** Display Mode Control Port **********************************************/

#define DMCP 0x03b8  /* Display Mode Control Port(Write Only) */

#define DMCP_TM   0x00  /* Text Mode                            */
#define DMCP_GM   0x02  /* Graphics Mode                        */
#define DMCP_DV   0x00  /* Disable Video(Blank Video Display)   */
#define DMCP_EV   0x08  /* Enable Video(Activate Video Display) */
#define DMCP_BON  0x00  /* Blink On                             */
#define DMCP_BOFF 0x20  /* Blink Off(Power-On Default)          */
#define DMCP_GP0  0x00  /* Graphics Page 0 Active               */
#define DMCP_GP1  0x80  /* Graphics Page 1 Active               */


/** Display Status Port ****************************************************/

#define DSP 0x03ba  /* Display Status Port(Read Only) */

#define DSP_VR 0x00  /* Vertical Retrace */
#define DSP_AD 0x80  /* Active Display   */

/** Light Pen Port *********************************************************/

#define SLPFF 0x03b9  /* Set Light Pen Flip Flop(Write Only)   */
#define RLPFF 0x03bb  /* Reset Light Pen Flip Flop(Write Only) */


/** Configuration Switch ***************************************************/

#define CS 0x03bf  /* Configuration Switch(Read/Write) */

#define CS_DIAG 0  /* DIAG Configuration(only   0xb0000 ~ 0xb0fff used) */
#define CS_HALF 1  /* HALF Configuration(only   0xb0000 ~ 0xb7fff used) */
#define CS_FULL 3  /* FULL Configuration(all of 0xb0000 ~ 0xbffff used) */

#endif
