/*
 *      File HANWOUT.H
 *      A Header for Windowed Output Functions
 *      '92.4.24-25, 5.3,24
 *      '93.5.6, 7.13, 8.4
 *      Written by Lim, I.K.
 */


#ifndef _HANWOUT_H_
#define _HANWOUT_H_

#ifndef _CHKVER_H_
    #include "chkver.h"
#endif

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Macro constants ********************************************************/

/* Output modes, parameters to hsetoutputmode function */

#ifndef OVERWRITE
    #define OVERWRITE         (&_putfont16)     /* 8x16, 16x16 font */
    #define OVERLAP           (&_putORfont16)
    #define OVERWRITE_ENLARGE (&_putfontx16)    /* Enlarged font    */
    #define OVERLAP_ENLARGE   (&_putORfontx16)
#endif


/** Type definitions *******************************************************/

#ifndef PUTFONT_T
    #define PUTFONT_T
    typedef struct {
        void (far **hputfont)(int, int, void far *, int, int);
        void (far **eputfont)(int, int, void far *, int, int);
        int charspace, linespace;
    } putfont_t;
#endif

#ifndef ONOFF_T
    #define ONOFF_T
    typedef enum {OFF, ON} onoff_t;
#endif

#if !defined(__GRAPHX_DEF_) && !defined(__GRAPHICS_H) && !defined(_HANOUT_H_)
    enum text_just {
        LEFT_TEXT = 0,
        CENTER_TEXT = 1,
        RIGHT_TEXT = 2,
        BOTTOM_TEXT = 0,  /* Not supported */
        TOP_TEXT = 2,     /* Not supported */
    };
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Output characters to the specified window */

int  wprintf(window_t *win, const byte *format, ...);
int  wprintfxy(window_t *win, int x, int y, const byte *format, ...);
int  wprintfpxy(window_t *win, int px, int py, const byte *format, ...);
void wputs(window_t *win, const byte *s);
void wputsxy(window_t *win, int x, int y, const byte *s);
void wputspxy(window_t *win, int px, int py, const byte *s);
void wputsnxy(window_t *win, int x, int y, size_t n, const byte *s);
void wputsnpxy(window_t *win, int px, int py, size_t n, const byte *s);

void weputs(window_t *win, const byte *s);
void weputsxy(window_t *win, int x, int y, const byte *s);
void weputspxy(window_t *win, int px, int py, const byte *s);

int wputch(window_t *win, int c);
int weputch(window_t *win, int c);

/* Set the current attribute */

void wsetbold(window_t *win, int flag);
void wsetoutline(window_t *win, int flag);
void wsetthreed(window_t *win, int flag);
void wsetfaint(window_t *win, int flag);
void wsetshadow(window_t *win, int flag);
void wsetunder(window_t *win, int flag);
void wsetframe(window_t *win, int flag);
void wsetblock(window_t *win, int flag);
void wsetreverse(window_t *win, int flag);

/* Set to the normal attribute */

void wnormattr(window_t *win);

/* Query the current attribute */

bool wisbold(window_t *win);
bool wisoutline(window_t *win);
bool wisthreed(window_t *win);
bool wisfaint(window_t *win);
bool wisshadow(window_t *win);
bool wisunder(window_t *win);
bool wisframe(window_t *win);
bool wisblock(window_t *win);
bool wisreverse(window_t *win);

/* Allow autoscroll when scroll needed */

void wallowautoscroll(window_t *win, bool allow);

/* Manipulate the specified window */

void wclrscr(window_t *win);
void wscroll(window_t *win);
void wbackscroll(window_t *win);

/* Set Hangul/graphics coordinates in the specified window */

void wgotoxy(window_t *win, int wx, int wy);
void wgotopxy(window_t *win, int wpx, int wpy);

/* Set text justification */

void wsettextjustify(window_t *win, int horiz);

/* Set tab size */

void wsettabsize(window_t *win, int tabsize);

/* Set output mode */

void wsetoutputmode(window_t *win, putfont_t *mode);

/* Register HAN/ENG/AUX/HGR/EGR/KSS fonts respectively */

void wregisterhanfont(window_t *win, hanfont_t hanfont);
void wregisterengfont(window_t *win, engfont_t engfont);
void wregisterauxfont(window_t *win, auxfont_t auxfont);
void wregisterhgrfont(window_t *win, hgrfont_t hgrfont);
void wregisteregrfont(window_t *win, egrfont_t egrfont);
void wregisterkssfont(window_t *win, kssfont_t kssfont);

/* Get HAN/ENG/AUX/HGR/EGR fonts respectively */

hanfont_t wgethanfont(window_t *win);
engfont_t wgetengfont(window_t *win);
auxfont_t wgetauxfont(window_t *win);
hgrfont_t wgethgrfont(window_t *win);
egrfont_t wgetegrfont(window_t *win);
kssfont_t wgetkssfont(window_t *win);

/* Mouse interface */

int mou__entry(int px, int py, int width, int height);
int mou__exit(void);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Set the current foreground and background colors */

#define wsetcolor(win, color)   ((win)->forecolor = (color))
#define wsetbkcolor(win, color) ((win)->backcolor = (color))

/* Get the current foreground and background colors */

#define wgetcolor(win)   ((win)->forecolor)
#define wgetbkcolor(win) ((win)->backcolor)

/* Mouse interface */

#define mou_entry(px, py, width, height) \
        ((_mouhiddenlevel == 0) ? mou__entry(px, py, width, height) : 0)
#define mou_exit() ((_mouhiddenlevel == 0) ? mou__exit() : 0)


/** External variables *****************************************************/

/* A hook vector called right after a character output */
/* by any of Hangul output functions                   */
/* The default is NULL                                 */

extern void (*_hookputch)(window_t *win, byte c, int apx, int apy);

/* A hook vector called when the window is needed to be scrolled  */
/* not by scroll functions (hscroll, etc)                         */
/* but by any of Hangul output functions                          */
/* If allowautoscroll(OFF), this vector will not be called at all */
/* The default is NULL                                            */

extern void (*_hookscroll)(wincoord_t *wc, window_t *win);

/* If false, blank lines won't be cleared when scroll */
/* The default is true                                */

extern bool _clearblankline;

/* The mouse hidden level, used only when the mouse is initialized */

extern const int _mouhiddenlevel;

#endif
