/*
 *      File HANWCORD.H
 *      Windowed Coordinates
 *      '92.4.24-25, 5.10-11, 8.4
 *      Written by Lim, I.K.
 */


#ifndef _HANWCORD_H_
#define _HANWCORD_H_

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Macro constant *********************************************************/

#ifndef DEFWIN
    #define DEFWIN (&_defwin)  /* A pointer to the default window */
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Set text/graphics coordinates in the specified window */

void wgotoxy(window_t *win, int x, int y);
void wgotopxy(window_t *win, int px, int py);

/* Set a specified output window */

int hsetwindow(window_t *win, int left, int top, int right, int bottom,
               int forecolor, int backcolor, window_t *defwin);
int hsetwindowpxy(window_t *win, int left, int top, int right, int bottom,
                  int forecolor, int backcolor, window_t *defwin);

/* Set the current output window to a specified output window */

void hsetcurwindow(window_t *win);

int htempcurwindow(window_t *win);
int hlastcurwindow(void);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Coordinates conversion */

/* text -> graphics */

#define wx2wpx(win, wx) (((wx) - 1) * (win)->charspace)
#define wy2wpy(win, wy) (((wy) - 1) * (win)->linespace)

/* graphics -> text */

#define wpx2wx(win, wpx) ((wpx) / (win)->charspace + 1)
#define wpy2wy(win, wpy) ((wpy) / (win)->linespace + 1)

/* graphics -> absolute graphics */

#define wpx2apx(win, wpx) ((win)->left + (wpx))
#define wpy2apy(win, wpy) ((win)->top + (wpy))

/* absolute graphics -> graphics */

#define apx2wpx(win, apx) ((apx) - (win)->left)
#define apy2wpy(win, apy) ((apy) - (win)->top)

/* text -> absolute graphics */

#define wx2apx(win, wx) wpx2apx(win, wx2wpx(win, wx))
#define wy2apy(win, wy) wpy2apy(win, wy2wpy(win, wy))

/* absolute graphics -> text */

#define apx2wx(win, apx) wpx2wx(win, apx2wpx(win, apx))
#define apy2wy(win, apy) wpy2wy(win, apy2wpy(win, apy))

/* text -> absolute text */

#define wx2ax(win, wx) wpx2wx(_FW, wx2apx(win, wx))
#define wy2ay(win, wy) wpy2wy(_FW, wy2apy(win, wy))

/* absolute text -> text */

#define ax2wx(win, ax) apx2wx(win, wx2wpx(_FW, ax))
#define ay2wy(win, ay) apy2wy(win, wx2wpx(_FW, ay))

/* graphics -> absolute text */

#define wpx2ax(win, wpx) wpx2wx(_FW, wpx2apx(win, wpx))
#define wpy2ay(win, wpy) wpy2wy(_FW, wpy2apy(win, wpy))

/* absolute text -> graphics */

#define ax2wpx(win, ax) apx2wpx(win, wx2wpx(_FW, ax))
#define ay2wpy(win, ay) apy2wpy(win, wy2wpy(_FW, ay))

/* one text -> another text */

#define wx2wx(win1, wx, win2) apx2wx(win2, wx2apx(win1, wx))
#define wy2wy(win1, wy, win2) apy2wy(win2, wy2apy(win1, wy))

/* one graphics -> another graphics */

#define wpx2wpx(win1, wpx, win2) apx2wpx(win2, wpx2apx(win1, wpx))
#define wpy2wpy(win1, wpy, win2) apy2wpy(win2, wpy2apy(win1, wpy))

/* Get the current text coordinates in the current window */

#define wwherex(win) apx2wx(win, (win)->apx)
#define wwherey(win) apy2wy(win, (win)->apy)

/* Get the current graphics coordinates in the current window */

#define wgetpx(win) apx2wpx(win, (win)->apx)
#define wgetpy(win) apy2wpy(win, (win)->apy)

/* Get the maximum values of coordinates */

#define wgetmaxx(win) ((win)->width / (win)->charspace)
#define wgetmaxy(win) ((win)->height / (win)->linespace)

#define wgetmaxpx(win) ((win)->width - 1)
#define wgetmaxpy(win) ((win)->height - 1)


/** External variables *****************************************************/

/* A pointer to the current output window */
/* The default is &_defwin                */

extern window_t *_CW;

/* A pointer to the fullscreen output window */
/* The default is &_fullscrwin               */

extern window_t *_FW;

/* The default output window */

extern window_t _defwin;

/* The fullscreen output window */

extern window_t _fullscrwin;

/* _maxtempcurwindowlevel defines the maximum nest level */
/* for calling htempcurwindow                            */
/* This variable must be set                             */
/* before first calling of the htempcurwindow function   */
/* The default is 10                                     */
/* _tempcurwindowlevel is the current nest level         */

extern int _maxtempcurwindowlevel;
extern int _tempcurwindowlevel;

#endif
