/*
 *      File HANTYPES.H
 *      Types Used in Hangul Lib
 *      '92.5.10,13,22-24
 *      '93.1.5, 7.20
 *      Written by Lim, I.K.
 */


#ifndef _HANTYPES_H_
#define _HANTYPES_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Macro constant *********************************************************/

#ifndef MAXFONTINDEX
    #define MAXFONTINDEX 21
#endif


/** Type definitions *******************************************************/

#ifndef _FONTTYPES
    #define _FONTTYPES

    typedef void far *linkedin_font_t;

    typedef const byte (*fontindex_t)[2][MAXFONTINDEX + 1];

    struct linkedin_hanfont_t {
        linkedin_font_t HAN1;
        linkedin_font_t HAN2;
        linkedin_font_t HAN3;
        fontindex_t fontindex;
    };

    typedef struct linkedin_hanfont_t *hanfont_t;
    typedef linkedin_font_t engfont_t;
    typedef linkedin_font_t auxfont_t;
    typedef linkedin_font_t hgrfont_t;
    typedef linkedin_font_t egrfont_t;
    typedef linkedin_font_t kssfont_t;
    typedef linkedin_font_t hanjafont_t;
#endif

typedef struct {
    void (*bold)(void far *);
    void (*outline)(void far *);
    void (*threed)(void far *);
    void (*faint)(void far *);
    void (*shadow)(void far *);
    void (*under)(void far *);
    void (*frame)(void far *);
    void (*block)(void far *);
    void (*reverse)(void far *);
} attrfuncp_t;

typedef struct {

    /* Coordinates */

    int left, top, right, bottom;
    int width, height;
    int charspace, linespace;

    /* Cursor */

    int apx, apy;

    /* Colors */

    int forecolor, backcolor;

    /* Attributes */

    bool isnormattr;
    bool lastattr;
    attrfuncp_t hanattr;
    attrfuncp_t engattr;

    /* Fonts */

    hanfont_t HAN;
    linkedin_font_t HAN1;
    linkedin_font_t HAN2;
    linkedin_font_t HAN3;
    fontindex_t fontindex;
    engfont_t ENG;
    auxfont_t AUX;
    hgrfont_t HGR;
    egrfont_t EGR;
    kssfont_t KSS;

    /* Pointers to output functions */

    int (*hputchapxy)(byte code1, byte code2, int apx, int apy);
    int (*eputchapxy)(byte c, int apx, int apy);

    void (far **hputfont)(int, int, void far *, int, int);
    void (far **eputfont)(int, int, void far *, int, int);

    /* Pointer to autoscroll function */

    void (*autoscroll)(void);

    /* Other options */

    int tabsize;
    int textjustify;

    /* Internal use */

    byte hputchbuf;

} window_t;

typedef struct {
    int left, top, right, bottom;
    int width, height;
} wincoord_t;

#endif
