/*
 *      File HANSW.H
 *      Switches
 *      '91.2.13, 7.12, 2.5
 *      '92.3.3, 5.3,22, 12.22
 *      '93.10.24
 *      Written by Lim, I.K.
 */


#ifndef _HANSW_H_
#define _HANSW_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Switches ***************************************************************/

/* Note: All px and py are absolute graphics coordinates */

extern void (far *_hputfont8x16)(int px, int py, void far *font,
                                 int forecolor, int backcolor);
extern void (far *_hputfont16x16)(int px, int py, void far *font,
                                  int forecolor, int backcolor);
extern void (far *_hputORfont8x16)(int px, int py, void far *font, int color);
extern void (far *_hputORfont16x16)(int px, int py, void far *font, int color);
extern void (far *_hclrscr)(int px, int py, int width, int height, int color);
extern void (far *_hscroll)(int px, int py, int width, int height, int line);
extern void (far *_hbackscroll)(int px, int py, int width, int height,
                                int line);
extern void (far *_hgetimage)(int px, int py, int width, int height,
                              void far *destin);
extern void (far *_hputimage)(int px, int py, int width, int height,
                              void far *source);
extern int  (far *_hgetpixel)(int px, int py);
extern void (far *_hputpixel)(int px, int py, int color);
extern void (far *_hhline)(int px, int py, int length, int color);
extern void (far *_hvline)(int px, int py, int length, int color);
extern void (far *_hputsprite)(int px, int py, int width, int height,
                               void far *shape, void far *bitmask);
extern void (far *_hsaveregs)(void);
extern void (far *_hloadregs)(void);
extern void (far *_hputfont8nx16m)(int px, int py, void far *font,
                                   int forecolor, int backcolor);
extern void (far *_hputfont16nx16m)(int px, int py, void far *font,
                                    int forecolor, int backcolor);
extern void (far *_hputORfont8nx16m)(int px, int py, void far *font, int color);
extern void (far *_hputORfont16nx16m)(int px, int py, void far *font, int color);
extern void (far *_BGIdriver)(void);
extern void (far *_SVGABGIdriver)(void);

/*
 *      Input:    _AL = The number of the bank
 *                If _AL == 0xff, increase the current bank
 *      Output:   _AX = Bank segment -> 0xa000 or 0xb000
 *      Modify:   Only _AX
 */
extern word far _hsetbank(void);

#endif
