/*
 *      File HANSVGA.H
 *      A header on Super VGA Chips
 *      '93.3.4-11,17,24, 5.1, 7.13
 *      Written by Lim, I.K.
 */


#ifndef _HANSVGA_H_
#define _HANSVGA_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Macro constants ********************************************************/

/* ID of Super VGA families */

#define SVGA_UNKNOWN     0  /* Unknown family              */
#define SVGA_VESA        1  /* VESA                        */
#define SVGA_ET3000      2  /* Tseng Laboratories, Inc.    */
#define SVGA_ET4000      3  /* Tseng Laboratories, Inc.    */
#define SVGA_ATI18800    4  /* ATI Technologies Inc.       */
#define SVGA_ATIX8800    5  /* ATI Technologies Inc.       */
#define SVGA_TVGA8800BR  6  /* Trident Microsystems, Inc.  */
#define SVGA_TVGA8X00    7  /* Trident Microsystems, Inc.  */
#define SVGA_WD90C00     8  /* Western Digital Corporation */
#define SVGA_WD90C1X     9  /* Western Digital Corporation */
#define SVGA_WD90C3X    10  /* Western Digital Corporation */
#define SVGA_M3121      11  /* Acer Inc.                   */
#define SVGA_OTI067     12  /* Oak Technology, Inc.        */
#define SVGA_AVGA2      13  /* Acumos Inc.                 */
#define SVGA_CLGD5X0    14  /* Cirrus Logic Inc.           */
#define SVGA_CLGD542X   15  /* Cirrus Logic Inc.           */
#define SVGA_USER       16  /* User board                  */

/* ID of Super VGA chips */

#define SVGACHIP_UNKNOWN       0  /* Unknown chip          */
#define SVGACHIP_VESA          1  /* VESA                  */
#define SVGACHIP_ET3000        2  /* ET3000AX, ET3000BX    */
#define SVGACHIP_ET4000        3  /* ET4000AX              */
#define SVGACHIP_ATI18800      4  /* 18800,   V3 boards    */
#define SVGACHIP_ATI18800_1    5  /* 18800-1, V4/V5 boards */
#define SVGACHIP_ATI28800      6  /* 28800-x, V60 boards   */
#define SVGACHIP_TVGA8800BR    7  /* TVGA8800BR            */
#define SVGACHIP_TVGA8800CS    8  /* TVGA8800CS            */
#define SVGACHIP_TVGA8900C     9  /* TVGA8900C             */
#define SVGACHIP_PVGA1A       10  /* PVGA1A                */
#define SVGACHIP_WD90C00      11  /* WD90C00               */
#define SVGACHIP_WD90C10      12  /* WD90C10               */
#define SVGACHIP_WD90C11      13  /* WD90C11               */
#define SVGACHIP_WD90C30      14  /* WD90C30               */
#define SVGACHIP_WD90C31      15  /* WD90C31               */
#define SVGACHIP_M3121        16  /* M3121                 */
#define SVGACHIP_OTI067       17  /* OTI-067               */
#define SVGACHIP_AVGA2        18  /* AVGA2                 */
#define SVGACHIP_CLGD5X0      19  /* CL-GD510/520          */
#define SVGACHIP_CLGD6X0      20  /* CL-GD610/620          */
#define SVGACHIP_CLGD5420     21  /* CL-GD5420             */
#define SVGACHIP_CLGD5422     22  /* CL-GD5422             */
#define SVGACHIP_CLGD5424     23  /* CL-GD5424             */
#define SVGACHIP_CLGD5426     24  /* CL-GD5426             */
#define SVGACHIP_USER         25  /* User chip             */

/* ID of Super VGA BIOS */

#define SVGABIOS_UNKNOWN    0  /* Unknown BIOS                */
#define SVGABIOS_VESA       1  /* VESA                        */
#define SVGABIOS_TSENGLABS  2  /* Tseng Laboratories, Inc.    */
#define SVGABIOS_ATI        3  /* ATI Technologies Inc.       */
#define SVGABIOS_TRIDENT    4  /* Trident Microsystems, Inc.  */
#define SVGABIOS_WDC        5  /* Western Digital Corporation */
#define SVGABIOS_ACER       6  /* Acer Inc.                   */
#define SVGABIOS_OTI        7  /* Oak Technology, Inc.        */
#define SVGABIOS_ACUMOS     8  /* Acumos Inc.                 */
#define SVGABIOS_GENOA      9  /* Genoa Systems Corporation   */
#define SVGABIOS_EVEREX    10  /* Everex Systems Inc.         */
#define SVGABIOS_CIRRUS    11  /* Cirrus Logic Inc.           */
#define SVGABIOS_EAGLE2    12  /* Eagle II VGA BIOS(Cirrus)   */
#define SVGABIOS_CIRRUS2   13  /* Cirrus Logic Inc.           */
#define SVGABIOS_USER      14  /* User BIOS                   */


/** Type definition ********************************************************/

/* Information on Super VGA */

#ifndef SVGAINFO_T
    #define SVGAINFO_T
    #ifdef __cplusplus
        #define _CONST
    #else
        #define _CONST const
    #endif
    typedef struct _svgainfo_t {
        _CONST int ID;   /* ID of Super VGA families                 */
        int biosID;      /* ID of detected Super VGA BIOS            */
        int chipID;      /* ID of detected Super VGA chips           */
        size_t memsize;  /* Detected on-board memory size in K bytes */
        bool rwbank;     /* R/W Dual Bank supported                  */
        bool (far *_CONST detectsvga)(void);
        byte (far *_CONST getmodenum)(int mode);
        bool (far *_CONST checkmemsize)(int mode);
        int  (far *_CONST setmode)(int mode);
        word (far *_CONST setbank)(void);
        struct _svgainfo_t far *nextinfo;
    } svgainfo_t;
#endif


/** Functions declarations *************************************************/

#ifdef __cplusplus
extern "C" {
#endif

void far addsvgalist(svgainfo_t far *svgainfo);
void far addhicollist(svgainfo_t far *hicolinfo);

svgainfo_t far *far detectsvga(void);   /* Autodetect Super VGAs          */
svgainfo_t far *far detecthicol(void);  /* Autodetect Hi-Color Super VGAs */

word far _getCAR(void);
bool far _detectportindex(word port, byte index, byte bitmask);
bool far _detectportindex2(word port, byte index, byte bitmask);
bool far _detectattrreg(byte index, byte bitmask);
bool far _detectport(word port, byte bitmask);

int far farmemcmp(const void far *s1, const void far *s2, size_t n);

#ifdef __cplusplus
}
#endif


/** External variables *****************************************************/

/* SVGA information of Super VGA chips */

extern svgainfo_t _svgainfo_VESA;
extern svgainfo_t _svgainfo_ET3000;
extern svgainfo_t _svgainfo_ET4000;
extern svgainfo_t _svgainfo_ATI18800;
extern svgainfo_t _svgainfo_ATIX8800;
extern svgainfo_t _svgainfo_TVGA8800BR;
extern svgainfo_t _svgainfo_TVGA8X00;
extern svgainfo_t _svgainfo_WD90C00;
extern svgainfo_t _svgainfo_WD90C1X;
extern svgainfo_t _svgainfo_WD90C3X;
extern svgainfo_t _svgainfo_M3121;
extern svgainfo_t _svgainfo_OTI067;
extern svgainfo_t _svgainfo_AVGA2;
extern svgainfo_t _svgainfo_CLGD5X0;
extern svgainfo_t _svgainfo_CLGD542X;
extern svgainfo_t _svgainfo_USER;

/* SVGA information of Hi-Color Super VGA chips */

extern svgainfo_t _hicolinfo_ET4000;

/* Required memory size for specified graphics mode */

extern size_t _hiresmemsize[];

/* The head of the linked list of SVGA informations */

extern svgainfo_t far *_svgainfolist;   /* For Hi-Res Mode   */
extern svgainfo_t far *_hicolinfolist;  /* For Hi-Color Mode */

/* Detected SVGA information */

extern svgainfo_t far *_cursvgainfo;   /* For Hi-Res Mode   */
extern svgainfo_t far *_curhicolinfo;  /* For Hi-Color Mode */

/* The starting segment address of the active display segment */

extern word _dispseg;

/* The current bank when Hi-Res and Hi-Color Modes */

extern byte _bank;

/* If true, R/W dual bank supported */

extern bool _rwbank;

#endif
