/*
 *      File HANSELCT.H
 *      Selectors
 *      '91.2.13,16, 3.19, 7.12, 11.1
 *      '92.2.5, 3.3, 5.22, 12.22
 *      '93.3.11
 *      Written by Lim, I.K.
 */


#ifndef _HANSELCT_H_
#define _HANSELCT_H_

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Type definition ********************************************************/

typedef void (far *selectorptr_t)(int);


/** Macro constants ********************************************************/

/* Selection modes */

#define AUTOSELECT _autoselect(_hanmode)
#define HGCMODE    1
#define EGAMODE    2
#define VGAMODE    3
#define HICMODE    4

/* Pre-defined selection tables */

#define SELECT_ALL      _all_select
#define SELECT_TEXTEMUL _textemul_select

#ifndef NULL
    #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
        #define NULL 0
    #else
        #define NULL 0L
    #endif
#endif


/** Selectors **************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* An overall selector to select switches listed in the selection table */

void far selecthan(selectorptr_t far *selecttable, int mode);

/* A selector to select all switches */

void far SELECT_all(int mode);

/* Selectors */

void far SELECT_hputfont8x16(int mode);
void far SELECT_hputfont16x16(int mode);
void far SELECT_hputORfont8x16(int mode);
void far SELECT_hputORfont16x16(int mode);
void far SELECT_hclrscr(int mode);
void far SELECT_hscroll(int mode);
void far SELECT_hbackscroll(int mode);
void far SELECT_hgetimage(int mode);
void far SELECT_hputimage(int mode);
void far SELECT_hgetpixel(int mode);
void far SELECT_hputpixel(int mode);
void far SELECT_hhline(int mode);
void far SELECT_hvline(int mode);
void far SELECT_hputsprite(int mode);
void far SELECT_hsaveregs(int mode);
void far SELECT_hloadregs(int mode);
void far SELECT_hputfont8nx16m(int mode);
void far SELECT_hputfont16nx16m(int mode);
void far SELECT_hputORfont8nx16m(int mode);
void far SELECT_hputORfont16nx16m(int mode);

/* Don't call these functions!!!                                */
/* These functions should be called by initialization functions */

void far SELECT_hsetbank(word (far *setbank)(void));

void far SELECT_BGIdriver(int mode);
void far SELECT_SVGABGIdriver(int mode);

/* Decide the selection mode automatically by hanmode */

int far _autoselect(int hanmode);

#ifdef __cplusplus
}
#endif


/** External variables *****************************************************/

extern const int _hanmode;

extern selectorptr_t _all_select[];
extern selectorptr_t _textemul_select[];

#endif
