/*
 *      File HANOUT.H
 *      A Header for Hangul Output Library
 *      '90.7.14-8.26
 *      '91.2.15-16, 4.22, 5.5-6, 7.10,15-16, 8.18,24,26
 *      '91.9.15, 10.17, 11.1,17, 12.26-29
 *      '92.1.4,6,25, 2.5, 5.10,24, 7.7
 *      '93.5.6,15
 *      Written by Lim, I.K.
 */


#ifndef _HANOUT_H_
#define _HANOUT_H_

#ifndef _CHKVER_H_
    #include "chkver.h"
#endif

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Macro constants ********************************************************/

/* Output modes, parameters to hsetoutputmode function */

#ifndef OVERWRITE
    #define OVERWRITE         (&_putfont16)     /* 8x16, 16x16 font */
    #define OVERLAP           (&_putORfont16)
    #define OVERWRITE_ENLARGE (&_putfontx16)    /* Enlarged font    */
    #define OVERLAP_ENLARGE   (&_putORfontx16)
#endif


/** Type definitions *******************************************************/

#ifndef PUTFONT_T
    #define PUTFONT_T
    typedef struct {
        void (far **hputfont)(int, int, void far *, int, int);
        void (far **eputfont)(int, int, void far *, int, int);
        int charspace, linespace;
    } putfont_t;
#endif

#ifndef ONOFF_T
    #define ONOFF_T
    typedef enum {OFF, ON} onoff_t;
#endif

#if !defined(__GRAPHX_DEF_) && !defined(__GRAPHICS_H) && !defined(_HANWOUT_H_)
    enum text_just {
        LEFT_TEXT = 0,
        CENTER_TEXT = 1,
        RIGHT_TEXT = 2,
        BOTTOM_TEXT = 0,  /* Not supported */
        TOP_TEXT = 2,     /* Not supported */
    };
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Output characters to the current window */

int  hprintf(const byte *format, ...);
int  hprintfxy(int x, int y, const byte *format, ...);
int  hprintfpxy(int px, int py, const byte *format, ...);
void hputs(const byte *s);
void hputsxy(int x, int y, const byte *s);
void hputspxy(int px, int py, const byte *s);
void hputsnxy(int x, int y, size_t n, const byte *s);
void hputsnpxy(int px, int py, size_t n, const byte *s);

void eputs(const byte *s);
void eputsxy(int x, int y, const byte *s);
void eputspxy(int px, int py, const byte *s);

int hputch(int c);
int eputch(int c);

/* Low level output */

int  _hputch(byte code1, byte code2);
void _eputch(byte c);

int  _hputchxy(byte code1, byte code2, int x, int y);
void _eputchxy(byte c, int x, int y);

int  _hputchpxy(byte code1, byte code2, int px, int py);
void _eputchpxy(byte c, int px, int py);

/* Output a number */

int hputnumdata(const char *string, const char *picture);
int hchecknumpicture(const char *string, const char *picture);

void hputlval(long lval, const byte *prefix);
int  hputdval(double dval, int width, int prec, const byte *prefix);

/* Set the current attribute */

void hsetbold(bool flag);
void hsetoutline(bool flag);
void hsetthreed(bool flag);
void hsetfaint(bool flag);
void hsetshadow(bool flag);
void hsetunder(bool flag);
void hsetframe(bool flag);
void hsetblock(bool flag);
void hsetreverse(bool flag);

/* Set to the normal attribute */

void hnormattr(void);

/* Query the current attribute */

bool isbold(void);
bool isoutline(void);
bool isthreed(void);
bool isfaint(void);
bool isshadow(void);
bool isunder(void);
bool isframe(void);
bool isblock(void);
bool isreverse(void);

/* Allow autoscroll when scroll needed */

void hallowautoscroll(bool allow);

/* Manipulate the graphics screen */

void hclrscr(void);
int  hclrscrxy(int x1, int y1, int x2, int y2);
int  hclrscrpxy(int px1, int py1, int px2, int py2);
int  hsolidbar(int x1, int y1, int x2, int y2, int color);
int  hsolidbarpxy(int px1, int py1, int px2, int py2, int color);

void hscroll(void);
void hbackscroll(void);
int  hscrollxy(int x1, int y1, int x2, int y2, int line);
int  hscrollpxy(int px1, int py1, int px2, int py2, int line);
int  hbackscrollxy(int x1, int y1, int x2, int y2, int line);
int  hbackscrollpxy(int px1, int py1, int px2, int py2, int line);

long htextsize(int x1, int y1, int x2, int y2);
int  hgettext(int x1, int y1, int x2, int y2, void far *destin);
int  hputtext(int x1, int y1, int x2, int y2, void far *source);
long himagesize(int px1, int py1, int px2, int py2);
int  hgetimage(int px1, int py1, int px2, int py2, void far *bitmap);
int  hputimage(int px, int py, void far *bitmap);

void hhline(int px, int py, int length, int color);
void hvline(int px, int py, int length, int color);

int  hgetpixel(int px, int py);
void hputpixel(int px, int py, int color);

int  hputsprite(int px1, int py1, int px2, int py2,
                void far *shape, void far *bitmask);

/* Set Hangul/graphics coordinates in the current window */

void hgotoxy(int x, int y);
void hgotopxy(int px, int py);

/* Set text justification, refer to settextjustify function of Turbo C */

void hsettextjustify(int horiz);

/* Set tab size */

void hsettabsize(int tabsize);

/* Set character output mode */

void hsetoutputmode(putfont_t *mode);

/* Set magnification factors of enlarged font */

void hsetenlarge(int xmag, int ymag);

/* Handle low level key input */

bool keypressed(void);
int  getxch(void);
int  getkey(void);
int  ungetxch(int c);
int  _bioskey(int cmd);

/* Get/set bank(display page) of SVGA                       */
/* Use only in interrupt handlers or BGI interface routines */

int       hgetbank(void);
word      hgetbankseg(void);
void far *hsetbank(int bank);

/* Miscellaneos */

void far farmemcpy(void far *dest, const void far *src, size_t n);
int  far farmemcmp(const void far *s1, const void far *s2, size_t n);
void far farmemadd(void far *dest, void far *src, int n);

/* Mouse interface */

int mou__entry(int px, int py, int width, int height);
int mou__exit(void);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Handle low level key input */

#define getchext()    getxch()
#define ungetchext(c) ungetxch(c)
#define pause()       ((void)getxch())

/* Mouse interface */

#define mou_entry(px, py, width, height) \
        ((_mouhiddenlevel == 0) ? mou__entry(px, py, width, height) : 0)
#define mou_exit() ((_mouhiddenlevel == 0) ? mou__exit() : 0)


/** External variables *****************************************************/

/* Function pointers, hrestorecrtmode and hsetgraphmode */

extern void (far *hrestorecrtmode)(void);
extern void (far *hsetgraphmode)(void);

/* Information on character output modes */

extern putfont_t _putfont16;     /* 8x16, 16x16 font */
extern putfont_t _putORfont16;
extern putfont_t _putfontx16;    /* Enlarged font    */
extern putfont_t _putORfontx16;

/* Function pointers(switches), _hgetpixel/_hputpixel   */
/* Faster than hgetpixel/hputpixel functions,           */
/* but uses absolute coordinates                        */
/* Use these functions only in speed-dependent routines */

extern int  (far *_hgetpixel)(int px, int py);
extern void (far *_hputpixel)(int px, int py, int color);

/* A hook vector called right after a character output */
/* by any of Hangul output functions                   */
/* The default is NULL                                 */

extern void (*_hookputch)(window_t *win, byte c, int apx, int apy);

/* A hook vector called when the window is needed to be scrolled  */
/* not by scroll functions (hscroll, etc)                         */
/* but by any of Hangul output functions                          */
/* If allowautoscroll(OFF), this vector will not be called at all */
/* The default is NULL                                            */

extern void (*_hookscroll)(wincoord_t *wc, window_t *win);

/* A hook vector to hook no code */

extern int (*_hooknocode)(byte code1, byte code2,
                          void *fontbuf, int width, int height);

/* The first byte of Hangul graphics character codes */
/* The default is 0xd4(212)                          */

extern byte _HGR1st;

/* The offset to the 2nd byte of Hangul graphics characters */
/* The default is 0x80(128)                                 */

extern byte _HGR2nd;

/* If false, blanks won't be cleared when backspace characters('\b') output */
/* The default is true                                                      */

extern bool _clearblank;

/* If false, blank lines won't be cleared when scroll */
/* The default is true                                */

extern bool _clearblankline;

/* The height of the reversed portion of characters */
/* having block attribute                           */
/* Range: 0 ~ 16                                    */
/* The default is 8 (half height)                   */

extern int _blockheight;

/* If true, '\n'(LF) will be a newline(CR/LF pair), */
/* otherwise '\n' will be a linefeed(LF) only       */
/* The default is true                              */

extern bool _islinefeednewline;

/* If true, all control code will not be recognized */
/* The default is false                             */

extern bool _noctrlcode;

/* An option of hputch                                 */
/* If true, the cursor will advance                    */
/* when the 1st byte of the Hangul character is passed */
/* The default is false                                */

extern bool _allowhan1stcursormove;

/* An option of hgetnumdata, hputnumdata and hstrnumtopic functions */
/* If true, blanks after point '.' will be filled with zero '0'     */
/* otherwise will be left                                           */
/* The default is true                                              */

extern bool _filltailblankzero;

/* An option of hgetnumdata, hputnumdata and hchecknumpicture functions */
/* If false, the parameter picture will not be checked anyway           */
/* Otherwise picture will fully be checked for safety                   */
/* Normally, if picture is a (valid) string constant                    */
/* this option may be set false to speed up, especially for hputnumdata */
/* The default is true                                                  */

extern bool _checknumpicture;

/* Options of hputlval and hputdval functions */

extern bool _putplussign;      /* The default is false */
extern bool _signafterprefix;  /* The default is false */

/* Options of hputlval function */

extern int  _outputradix;  /* The default is 10   */
extern bool _putcomma;     /* The default is true */

/* Options of hputdval function */

extern const char *_hugedval;  /* The default is "+OVERFLOW" */

/* The mouse hidden level, used only when the mouse is initialized */

extern const int _mouhiddenlevel;

#endif
