/*
 *      File HANMODE.H
 *      A Header for Initializing Hangul Modes
 *      '92.2.5
 *      '93.7.25
 *      Written by Lim, I.K.
 */


#ifndef _HANMODE_H_
#define _HANMODE_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Macro constants ********************************************************/

/* Initialization modes of the Hangul Library */

#define FIXRESMODE     initfixreshan    /* Fixed Resolution Mode    */
#define STDMODE        initstdhan       /* Normal Standard Mode     */
#define BGIMODE        initbgihan       /* Normal BGI Mode          */
#define HIRESSTDMODE   inithiresstdhan  /* Hi-Res Standard Mode     */
#define HIRESBGIMODE   inithiresbgihan  /* Hi-Res BGI Mode          */
#define HICOLSTDMODE   inithicolstdhan  /* Hi-Color Standard Mode   */
#define HICOLBGIMODE   inithicolbgihan  /* Hi-Color BGI Mode        */
#define TRUESTDMODE    /* N/A */        /* True-Color Standard Mode */
#define TRUEBGIMODE    /* N/A */        /* True-Color BGI Mode      */

/* Normal Hangul modes                  */
/* HGC: Hercules Graphics Card(Adapter) */
/* EGA: Enhanced Graphics Adapter       */
/* VGA: Video Graphics Array            */

#define HANDETECT     0  /* Autodetection             */
#define HANHGC        1  /* HGC           640x400x2   */
#define HANEGA        2  /* EGA           640x350x16  */
#define HANVGA        3  /* Standard VGA  640x480x16  */
#define HANVGA320HI   4  /* Standard VGA  320x200x256 */
#define HANVGA640X400 5  /* Standard VGA  640x400x16  */
#define HANCGA640     6  /* Modified CGA  640x400x2   */  /* N/A */

/* SVGA Hangul modes (SVGA: Super VGA) */

#define HANSVGA640HI  11  /* Super VGA  640x480x256 */
#define HANSVGA800LO  12  /* Super VGA  800x600x16  */
#define HANSVGA800HI  13  /* Super VGA  800x600x256 */
#define HANSVGA1024LO 14  /* Super VGA 1024x768x16  */  /* N/A */
#define HANSVGA1024HI 15  /* Super VGA 1024x768x256 */

/* Hi-Color SVGA Hangul modes */

#define HANHICOL640LO 21  /* Hi-Color Super VGA 640x480x32768 */
#define HANHICOL640HI 22  /* Hi-Color Super VGA 640x480x65536 */  /* N/A */
#define HANHICOL800LO 23  /* Hi-Color Super VGA 800x600x32768 */
#define HANHICOL800HI 24  /* Hi-Color Super VGA 800x600x65536 */  /* N/A */

/* True-Color SVGA Hangul modes */

#define HANTRUE640 31  /* True-Color Super VGA 640x480x16M */  /* N/A */

/* Limits */

#define MAXHANMODE 40
#define MAXHIRESHANMODE (HANSVGA1024HI - HANSVGA640HI + 1)
#define MAXHICOLHANMODE (HANHICOL800HI - HANHICOL640LO + 1)
#define MAXTRUEHANMODE (HANTRUE640 - HANTRUE640 + 1)


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize the Hangul Library and the graphics mode */

int initfixreshan(int hanmode);    /* For Fixed Resolution Mode    */
int initstdhan(int hanmode);       /* For Normal Standard Mode     */
int initbgihan(int hanmode);       /* For Normal BGI Mode          */
int inithiresstdhan(int hanmode);  /* For Hi-Res Standard Mode     */
int inithiresbgihan(int hanmode);  /* For Hi-Res BGI Mode          */
int inithicolstdhan(int hanmode);  /* For Hi-Color Standard Mode   */
int inithicolbgihan(int hanmode);  /* For Hi-Color BGI Mode        */
int inittruestdhan(int hanmode);   /* For True-Color Standard Mode */  /* N/A */
int inittruebgihan(int hanmode);   /* For True-Color BGI Mode      */  /* N/A */

/* Close the Hangul Library and the graphics mode */

void closehan(void);

#ifdef __cplusplus
}
#endif


/** External variables *****************************************************/

/* The current Hangul mode of the Hangul System */

extern const int _hanmode;

/* Allow mode setting when initialize the Hangul System or exit the program */
/* If false,                                                                */
/* user must call the hsetgraphmode function or the BIOS interrupt          */
/* during the initialization procedure,                                     */
/* and must call hrestorecrtmode or the BIOS interrupt                      */
/* before exit the program                                                  */
/* This option is effective                                                 */
/* ONLY in Standard Modes NOT in BGI Modes                                  */
/* The default is true                                                      */

extern bool _allowmodesetting;

/* The active display page of HGC or EGA */
/* The value is either 0 or 1            */
/* Must be set before initialization     */
/* The default is 0                      */

extern int _page;

/* Indicate whether in Standard Modes or in BGI Modes */
/* including Hi-Res Modes and Hi-Color Modes          */

extern const bool _isstdmode;

/* If true, in graphics mode                          */
/* else in text mode(the alphanumeric mode)           */
/* Set by hrestorecrtmode and hsetgraphmode functions */

extern const bool _isgraphmode;

#endif
