/*
 *      File HANLINK.H
 *      Device Linkers
 *      '91.2.13,16-17, 3.19, 5.8, 7.12, 8.26, 11.1, 12.26-27
 *      '92.1.25, 2.5, 5.22, 12.22
 *      '93.3.3-4,11, 7.25, 10.23-24
 *      Written by Lim, I.K.
 */


#ifndef _HANLINK_H_
#define _HANLINK_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Type definition ********************************************************/

typedef void (far *linkerptr_t)(void);


/** Macro constants ********************************************************/

/* Pre-defined link tables */

#define FIXRESMODE_HANDETECT_ALL       _stdhan_HGCEGA_all_link
#define FIXRESMODE_HANHGC_ALL          _stdhan_HGC_all_link
#define FIXRESMODE_HANVGA640X400_ALL   _stdhan_EGA_all_link
#define FIXRESMODE_HANCGA640_ALL       /* N/A */
#define STDMODE_HANDETECT_ALL          _stdhan_HGCEGA_all_link
#define STDMODE_HANHGC_ALL             _stdhan_HGC_all_link
#define STDMODE_HANEGA_ALL             _stdhan_EGA_all_link
#define STDMODE_HANVGA_ALL             _stdhan_EGA_all_link
#define STDMODE_HANVGA320HI_ALL        _stdhan_VGA_all_link
#define BGIMODE_HANDETECT_ALL          _bgihan_HGCEGA_all_link
#define BGIMODE_HANHGC_ALL             _bgihan_HGC_all_link
#define BGIMODE_HANEGA_ALL             _bgihan_EGA_all_link
#define BGIMODE_HANVGA_ALL             _bgihan_EGA_all_link
#define BGIMODE_HANVGA320HI_ALL        _bgihan_VGA_all_link
#define HIRESSTDMODE_HANSVGA640HI_ALL  _hiresstdhan_VGA_all_link
#define HIRESSTDMODE_HANSVGA800LO_ALL  _hiresstdhan_EGA_all_link
#define HIRESSTDMODE_HANSVGA800HI_ALL  _hiresstdhan_VGA_all_link
#define HIRESSTDMODE_HANSVGA1024LO_ALL /* N/A */
#define HIRESSTDMODE_HANSVGA1024HI_ALL _hiresstdhan_VGA_all_link
#define HIRESBGIMODE_HANSVGA640HI_ALL  _hiresbgihan_VGA_all_link
#define HIRESBGIMODE_HANSVGA800LO_ALL  _hiresbgihan_EGA_all_link
#define HIRESBGIMODE_HANSVGA800HI_ALL  _hiresbgihan_VGA_all_link
#define HIRESBGIMODE_HANSVGA1024LO_ALL /* N/A */
#define HIRESBGIMODE_HANSVGA1024HI_ALL _hiresbgihan_VGA_all_link
#define HICOLSTDMODE_HANHICOL640LO_ALL _hicolstdhan_HIC_all_link
#define HICOLSTDMODE_HANHICOL640HI_ALL _hicolstdhan_HIC_all_link
#define HICOLSTDMODE_HANHICOL800LO_ALL _hicolstdhan_HIC_all_link
#define HICOLSTDMODE_HANHICOL800HI_ALL _hicolstdhan_HIC_all_link
#define HICOLBGIMODE_HANHICOL640LO_ALL _hicolbgihan_HIC_all_link
#define HICOLBGIMODE_HANHICOL640HI_ALL _hicolbgihan_HIC_all_link
#define HICOLBGIMODE_HANHICOL800LO_ALL _hicolbgihan_HIC_all_link
#define HICOLBGIMODE_HANHICOL800HI_ALL _hicolbgihan_HIC_all_link
#define TRUESTDMODE_HANTRUE640_ALL     /* N/A */

#define FIXRESMODE_HANDETECT_TEXTEMUL       _stdhan_HGCEGA_textemul_link
#define FIXRESMODE_HANHGC_TEXTEMUL          _stdhan_HGC_textemul_link
#define FIXRESMODE_HANVGA640X400_TEXTEMUL   _stdhan_EGA_textemul_link
#define FIXRESMODE_HANCGA640_TEXTEMUL       /* N/A */
#define STDMODE_HANDETECT_TEXTEMUL          _stdhan_HGCEGA_textemul_link
#define STDMODE_HANHGC_TEXTEMUL             _stdhan_HGC_textemul_link
#define STDMODE_HANEGA_TEXTEMUL             _stdhan_EGA_textemul_link
#define STDMODE_HANVGA_TEXTEMUL             _stdhan_EGA_textemul_link
#define STDMODE_HANVGA320HI_TEXTEMUL        _stdhan_VGA_textemul_link
#define BGIMODE_HANDETECT_TEXTEMUL          _bgihan_HGCEGA_textemul_link
#define BGIMODE_HANHGC_TEXTEMUL             _bgihan_HGC_textemul_link
#define BGIMODE_HANEGA_TEXTEMUL             _bgihan_EGA_textemul_link
#define BGIMODE_HANVGA_TEXTEMUL             _bgihan_EGA_textemul_link
#define BGIMODE_HANVGA320HI_TEXTEMUL        _bgihan_VGA_textemul_link
#define HIRESSTDMODE_HANSVGA640HI_TEXTEMUL  _hiresstdhan_VGA_textemul_link
#define HIRESSTDMODE_HANSVGA800LO_TEXTEMUL  _hiresstdhan_EGA_textemul_link
#define HIRESSTDMODE_HANSVGA800HI_TEXTEMUL  _hiresstdhan_VGA_textemul_link
#define HIRESSTDMODE_HANSVGA1024LO_TEXTEMUL /* N/A */
#define HIRESSTDMODE_HANSVGA1024HI_TEXTEMUL _hiresstdhan_VGA_textemul_link
#define HIRESBGIMODE_HANSVGA640HI_TEXTEMUL  _hiresbgihan_VGA_textemul_link
#define HIRESBGIMODE_HANSVGA800LO_TEXTEMUL  _hiresbgihan_EGA_textemul_link
#define HIRESBGIMODE_HANSVGA800HI_TEXTEMUL  _hiresbgihan_VGA_textemul_link
#define HIRESBGIMODE_HANSVGA1024LO_TEXTEMUL /* N/A */
#define HIRESBGIMODE_HANSVGA1024HI_TEXTEMUL _hiresbgihan_VGA_textemul_link
#define HICOLSTDMODE_HANHICOL640LO_TEXTEMUL _hicolstdhan_HIC_textemul_link
#define HICOLSTDMODE_HANHICOL640HI_TEXTEMUL _hicolstdhan_HIC_textemul_link
#define HICOLSTDMODE_HANHICOL800LO_TEXTEMUL _hicolstdhan_HIC_textemul_link
#define HICOLSTDMODE_HANHICOL800HI_TEXTEMUL _hicolstdhan_HIC_textemul_link
#define HICOLBGIMODE_HANHICOL640LO_TEXTEMUL _hicolbgihan_HIC_textemul_link
#define HICOLBGIMODE_HANHICOL640HI_TEXTEMUL _hicolbgihan_HIC_textemul_link
#define HICOLBGIMODE_HANHICOL800LO_TEXTEMUL _hicolbgihan_HIC_textemul_link
#define HICOLBGIMODE_HANHICOL800HI_TEXTEMUL _hicolbgihan_HIC_textemul_link
#define TRUESTDMODE_HANTRUE640_TEXTEMUL     /* N/A */


/** Functions declarations *************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* An overall device linker to link connectors listed in the link table */

void far linkhan(linkerptr_t far *linktable);

/* Device linkers to link all connectors of the specified mode */

void far LINK_HGC_all(void);
void far LINK_EGA_all(void);
void far LINK_VGA_all(void);
void far LINK_HIC_all(void);

/* Device linkers for HGC connectors */

void far LINK_HGC_hputfont8x16(void);
void far LINK_HGC_hputfont16x16(void);
void far LINK_HGC_hputORfont8x16(void);
void far LINK_HGC_hputORfont16x16(void);
void far LINK_HGC_hclrscr(void);
void far LINK_HGC_hscroll(void);
void far LINK_HGC_hbackscroll(void);
void far LINK_HGC_hgetimage(void);
void far LINK_HGC_hputimage(void);
void far LINK_HGC_hgetpixel(void);
void far LINK_HGC_hputpixel(void);
void far LINK_HGC_hhline(void);
void far LINK_HGC_hvline(void);
void far LINK_HGC_hputsprite(void);
void far LINK_HGC_hsaveregs(void);
void far LINK_HGC_hloadregs(void);
void far LINK_HGC_hputfont8nx16m(void);
void far LINK_HGC_hputfont16nx16m(void);
void far LINK_HGC_hputORfont8nx16m(void);
void far LINK_HGC_hputORfont16nx16m(void);

/* Device linkers for EGA connectors */

void far LINK_EGA_hputfont8x16(void);
void far LINK_EGA_hputfont16x16(void);
void far LINK_EGA_hputORfont8x16(void);
void far LINK_EGA_hputORfont16x16(void);
void far LINK_EGA_hclrscr(void);
void far LINK_EGA_hscroll(void);
void far LINK_EGA_hbackscroll(void);
void far LINK_EGA_hgetimage(void);
void far LINK_EGA_hputimage(void);
void far LINK_EGA_hgetpixel(void);
void far LINK_EGA_hputpixel(void);
void far LINK_EGA_hhline(void);
void far LINK_EGA_hvline(void);
void far LINK_EGA_hputsprite(void);
void far LINK_EGA_hsaveregs(void);
void far LINK_EGA_hloadregs(void);
void far LINK_EGA_hputfont8nx16m(void);
void far LINK_EGA_hputfont16nx16m(void);
void far LINK_EGA_hputORfont8nx16m(void);
void far LINK_EGA_hputORfont16nx16m(void);

/* Device linkers for VGA connectors */

void far LINK_VGA_hputfont8x16(void);
void far LINK_VGA_hputfont16x16(void);
void far LINK_VGA_hputORfont8x16(void);
void far LINK_VGA_hputORfont16x16(void);
void far LINK_VGA_hclrscr(void);
void far LINK_VGA_hscroll(void);
void far LINK_VGA_hbackscroll(void);
void far LINK_VGA_hgetimage(void);
void far LINK_VGA_hputimage(void);
void far LINK_VGA_hgetpixel(void);
void far LINK_VGA_hputpixel(void);
void far LINK_VGA_hhline(void);
void far LINK_VGA_hvline(void);
void far LINK_VGA_hputsprite(void);
void far LINK_VGA_hsaveregs(void);
void far LINK_VGA_hloadregs(void);
void far LINK_VGA_hputfont8nx16m(void);
void far LINK_VGA_hputfont16nx16m(void);
void far LINK_VGA_hputORfont8nx16m(void);
void far LINK_VGA_hputORfont16nx16m(void);

/* Device linkers for HIC connectors */

void far LINK_HIC_hputfont8x16(void);
void far LINK_HIC_hputfont16x16(void);
void far LINK_HIC_hputORfont8x16(void);
void far LINK_HIC_hputORfont16x16(void);
void far LINK_HIC_hclrscr(void);
void far LINK_HIC_hscroll(void);
void far LINK_HIC_hbackscroll(void);
void far LINK_HIC_hgetimage(void);
void far LINK_HIC_hputimage(void);
void far LINK_HIC_hgetpixel(void);
void far LINK_HIC_hputpixel(void);
void far LINK_HIC_hhline(void);
void far LINK_HIC_hvline(void);
void far LINK_HIC_hputsprite(void);
void far LINK_HIC_hsaveregs(void);
void far LINK_HIC_hloadregs(void);
void far LINK_HIC_hputfont8nx16m(void);
void far LINK_HIC_hputfont16nx16m(void);
void far LINK_HIC_hputORfont8nx16m(void);
void far LINK_HIC_hputORfont16nx16m(void);

/* Device linkers for the connectors of the _BGIdriver switch module */

void far LINK_HGC_BGIdriver(void);
void far LINK_EGA_BGIdriver(void);
void far LINK_VGA_BGIdriver(void);

/* Device linkers for the connectors of the _SVGABGIdriver switch module */

void far LINK_EGA_SVGABGIdriver(void);
void far LINK_VGA_SVGABGIdriver(void);
void far LINK_HIC_SVGABGIdriver(void);

/* Linker to connect all SVGA informations */

void far LINK_SVGA_all(void);
void far LINK_HICOL_all(void);

#ifdef __cplusplus
}
#endif


/** External variables *****************************************************/

extern linkerptr_t _stdhan_HGCEGA_all_link[];
extern linkerptr_t _stdhan_HGC_all_link[];
extern linkerptr_t _stdhan_EGA_all_link[];
extern linkerptr_t _stdhan_VGA_all_link[];
extern linkerptr_t _hiresstdhan_EGA_all_link[];
extern linkerptr_t _hiresstdhan_VGA_all_link[];
extern linkerptr_t _hicolstdhan_HIC_all_link[];
extern linkerptr_t _truestdhan_TRU_all_link[];  /* N/A */

extern linkerptr_t _bgihan_HGCEGA_all_link[];
extern linkerptr_t _bgihan_HGC_all_link[];
extern linkerptr_t _bgihan_EGA_all_link[];
extern linkerptr_t _bgihan_VGA_all_link[];
extern linkerptr_t _hiresbgihan_EGA_all_link[];
extern linkerptr_t _hiresbgihan_VGA_all_link[];
extern linkerptr_t _hicolbgihan_HIC_all_link[];
extern linkerptr_t _truebgihan_TRU_all_link[];   /* N/A */

extern linkerptr_t _stdhan_HGCEGA_textemul_link[];
extern linkerptr_t _stdhan_HGC_textemul_link[];
extern linkerptr_t _stdhan_EGA_textemul_link[];
extern linkerptr_t _stdhan_VGA_textemul_link[];
extern linkerptr_t _hiresstdhan_EGA_textemul_link[];
extern linkerptr_t _hiresstdhan_VGA_textemul_link[];
extern linkerptr_t _hicolstdhan_HIC_textemul_link[];
extern linkerptr_t _truestdhan_TRU_textemul_link[];  /* N/A */

extern linkerptr_t _bgihan_HGCEGA_textemul_link[];
extern linkerptr_t _bgihan_HGC_textemul_link[];
extern linkerptr_t _bgihan_EGA_textemul_link[];
extern linkerptr_t _bgihan_VGA_textemul_link[];
extern linkerptr_t _hiresbgihan_EGA_textemul_link[];
extern linkerptr_t _hiresbgihan_VGA_textemul_link[];
extern linkerptr_t _hicolbgihan_HIC_textemul_link[];
extern linkerptr_t _truebgihan_TRU_textemul_link[];   /* N/A */

#endif
