/*
 *      File HANINIT.H
 *      A Header for Initializing Hangul Library
 *      '91.2.23,25, 3.19, 5.7, 8.26, 11.1,17, 12.26
 *      '92.1.1,6,25, 2.5
 *      '93.1.6, 5.1,15, 6.1, 10.25
 *      Written by Lim, I.K.
 */


#ifndef _HANINIT_H_
#define _HANINIT_H_

#ifndef _HANCOORD_H_
    #include "hancoord.h"
#endif

#ifndef _HANFONT_H_
    #include "hanfont.h"
#endif

#ifndef _HANLINK_H_
    #include "hanlink.h"
#endif

#ifndef _HANMODE_H_
    #include "hanmode.h"
#endif

#ifndef _HANSELCT_H_
    #include "hanselct.h"
#endif


/** Macro constants ********************************************************/

/* The version of the Hangul Library, currently V2.4 */

#define HANLIBVER  0x0240

/* The date of the Hangul Library, currently 1993.10.25 */

#define HANLIBDATE 0x931025L

/* Default Hangul and English fonts */

#define DEFHANFONT HAN10MD1
#define DEFENGFONT ENGMD1

/* Calling time, used in _hookclosehan */

#define CLOSEHAN_BEFORE 0
#define CLOSEHAN_AFTER  1


/** Type definition ********************************************************/

typedef int (*initmode_t)(int);


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize the Hangul Library and the graphics mode */

void inithan(initmode_t initmode, int hanmode,
             hanfont_t hanfont, engfont_t engfont);

/* Close the Hangul Library and the graphics mode */

void closehan(void);

/* Change the graphics mode */

void changehan(initmode_t initmode, int hanmode, window_t *defwin);

int _gethanmode(int graphdriver, int graphmode);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Initialize the Hangul System */

/* If Turbo C++ 1.0, Borland C++ 2.0 or later */
#if __TCPLUSPLUS__ >= 0x0100 || __TURBOC__ == 0x0295 \
    || __BORLANDC__ >= 0x0200 || __TURBOC__ == 0x0297 || __TURBOC__ >= 0x0400
    #ifdef TEXTEMUL
        #define inithanlib(initmode, hanmode, hanfont, engfont) ( \
            linkhan(initmode##_##hanmode##_TEXTEMUL),             \
            inithan(initmode, hanmode, hanfont, engfont),         \
            selecthan(SELECT_TEXTEMUL, AUTOSELECT)                \
        )
    #else
        #define inithanlib(initmode, hanmode, hanfont, engfont) ( \
            linkhan(initmode##_##hanmode##_ALL),                  \
            inithan(initmode, hanmode, hanfont, engfont),         \
            selecthan(SELECT_ALL, AUTOSELECT)                     \
        )
    #endif
/* If Turbo C 2.0 or 2.01 */
#elif __TURBOC__ == 0x0201 || __TURBOC__ == 0x0200 || __TURBOC__ == 0x018d
    #ifdef TEXTEMUL
        #define inithanlib(initmode, hanmode, hanfont, engfont) ( \
            linkhan(__##initmode##hanmode##textemul__),           \
            inithan(initmode, hanmode, hanfont, engfont),         \
            selecthan(SELECT_TEXTEMUL, AUTOSELECT)                \
        )
    #else
        #define inithanlib(initmode, hanmode, hanfont, engfont) ( \
            linkhan(__##initmode##hanmode##all__),                \
            inithan(initmode, hanmode, hanfont, engfont),         \
            selecthan(SELECT_ALL, AUTOSELECT)                     \
        )
    #endif
/* If Turbo C 1.0 or 1.5 */
#elif defined(__TURBOC__)
    #error Turbo C 1.0 and 1.5 are not supported. Use later version.
/* Other C compilers */
#else
    #error Compile with Turbo C 2.0, Turbo C++ 1.0, Borland C++ 2.0 or later.
#endif

#define initgraph(graphdriver, graphmode, pathtodriver)  \
        (_pathtodriver = pathtodriver,                   \
        linkhan(BGIHAN_HANDETECT_ALL),                   \
        initbgihan(_gethanmode(graphdriver, graphmode)), \
        selecthan(SELECT_ALL, AUTOSELECT))


/** External variables *****************************************************/

/* Link tables for Turbo C 2.0 */

extern linkerptr_t far *__initfixreshan0all__;
extern linkerptr_t far *__initfixreshan1all__;
extern linkerptr_t far *__initfixreshan5all__;
extern linkerptr_t far *__initstdhan0all__;
extern linkerptr_t far *__initstdhan1all__;
extern linkerptr_t far *__initstdhan2all__;
extern linkerptr_t far *__initstdhan3all__;
extern linkerptr_t far *__initstdhan4all__;
extern linkerptr_t far *__initbgihan0all__;
extern linkerptr_t far *__initbgihan1all__;
extern linkerptr_t far *__initbgihan2all__;
extern linkerptr_t far *__initbgihan3all__;
extern linkerptr_t far *__initbgihan4all__;
extern linkerptr_t far *__inithiresstdhan11all__;
extern linkerptr_t far *__inithiresstdhan12all__;
extern linkerptr_t far *__inithiresstdhan13all__;
extern linkerptr_t far *__inithiresstdhan14all__;
extern linkerptr_t far *__inithiresstdhan15all__;
extern linkerptr_t far *__inithiresbgihan11all__;
extern linkerptr_t far *__inithiresbgihan12all__;
extern linkerptr_t far *__inithiresbgihan13all__;
extern linkerptr_t far *__inithiresbgihan14all__;
extern linkerptr_t far *__inithiresbgihan15all__;
extern linkerptr_t far *__inithicolstdhan21all__;
extern linkerptr_t far *__inithicolstdhan22all__;
extern linkerptr_t far *__inithicolstdhan23all__;
extern linkerptr_t far *__inithicolstdhan24all__;

extern linkerptr_t far *__initfixreshan0textemul__;
extern linkerptr_t far *__initfixreshan1textemul__;
extern linkerptr_t far *__initfixreshan5textemul__;
extern linkerptr_t far *__initstdhan0textemul__;
extern linkerptr_t far *__initstdhan1textemul__;
extern linkerptr_t far *__initstdhan2textemul__;
extern linkerptr_t far *__initstdhan3textemul__;
extern linkerptr_t far *__initstdhan4textemul__;
extern linkerptr_t far *__initbgihan0textemul__;
extern linkerptr_t far *__initbgihan1textemul__;
extern linkerptr_t far *__initbgihan2textemul__;
extern linkerptr_t far *__initbgihan3textemul__;
extern linkerptr_t far *__initbgihan4textemul__;
extern linkerptr_t far *__inithiresstdhan11textemul__;
extern linkerptr_t far *__inithiresstdhan12textemul__;
extern linkerptr_t far *__inithiresstdhan13textemul__;
extern linkerptr_t far *__inithiresstdhan14textemul__;
extern linkerptr_t far *__inithiresstdhan15textemul__;
extern linkerptr_t far *__inithiresbgihan11textemul__;
extern linkerptr_t far *__inithiresbgihan12textemul__;
extern linkerptr_t far *__inithiresbgihan13textemul__;
extern linkerptr_t far *__inithiresbgihan14textemul__;
extern linkerptr_t far *__inithiresbgihan15textemul__;
extern linkerptr_t far *__inithicolstdhan21textemul__;
extern linkerptr_t far *__inithicolstdhan22textemul__;
extern linkerptr_t far *__inithicolstdhan23textemul__;
extern linkerptr_t far *__inithicolstdhan24textemul__;

/* The path to the BGI drivers, if needed, in BGI Mode */
/* The default is "", ie. the current directory        */

extern char *_pathtodriver;

/* A hook vector called when Hangul Library is closed */
/* by closehan function or program termination        */

extern void (*_hookclosehan)(int when);

/* The stack size is extended from 4096 byte to 8192 byte in Hangul Lib     */
/* This is only valid in large data models like Compact and Large Models    */
/* In small data models like Small and Medium,                              */
/* Total size of the static data, the near heap and the stack is always 64K */
/* If larger size needed, write the following code out of functions,        */
/* then _stklen defined in Hangul Library and Turbo C's Cx.LIB              */
/* will be ignored,                                                         */
/*                                                                          */
/* unsigned _stklen = nnnnn;                                                */
/*                                                                          */
/* where nnnnn is the byte size of the stack                                */

extern unsigned _stklen;

#endif
