/*
 *      File HANDEV.H
 *      Devices
 *      '91.2.13, 7.12, 11.16
 *      '92.2.5, 5.3,22, 12.22
 *      Written by Lim, I.K.
 */


#ifndef _HANDEV_H_
#define _HANDEV_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Devices ****************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Note: All px and py are absolute graphics coordinates */

void far HGC_hputfont8x16(int px, int py, void far *font,
                          int forecolor, int backcolor);
void far EGA_hputfont8x16(int px, int py, void far *font,
                          int forecolor, int backcolor);
void far VGA_hputfont8x16(int px, int py, void far *font,
                          int forecolor, int backcolor);
void far HIC_hputfont8x16(int px, int py, void far *font,
                          int forecolor, int backcolor);

void far HGC_hputfont16x16(int px, int py, void far *font,
                           int forecolor, int backcolor);
void far EGA_hputfont16x16(int px, int py, void far *font,
                           int forecolor, int backcolor);
void far VGA_hputfont16x16(int px, int py, void far *font,
                           int forecolor, int backcolor);
void far HIC_hputfont16x16(int px, int py, void far *font,
                           int forecolor, int backcolor);

void far HGC_hputORfont8x16(int px, int py, void far *font, int color);
void far EGA_hputORfont8x16(int px, int py, void far *font, int color);
void far VGA_hputORfont8x16(int px, int py, void far *font, int color);
void far HIC_hputORfont8x16(int px, int py, void far *font, int color);

void far HGC_hputORfont16x16(int px, int py, void far *font, int color);
void far EGA_hputORfont16x16(int px, int py, void far *font, int color);
void far VGA_hputORfont16x16(int px, int py, void far *font, int color);
void far HIC_hputORfont16x16(int px, int py, void far *font, int color);

void far HGC_hputfont8nx16m(int px, int py, void far *font,
                            int forecolor, int backcolor);
void far EGA_hputfont8nx16m(int px, int py, void far *font,
                            int forecolor, int backcolor);
void far VGA_hputfont8nx16m(int px, int py, void far *font,
                            int forecolor, int backcolor);
void far HIC_hputfont8nx16m(int px, int py, void far *font,
                            int forecolor, int backcolor);

void far HGC_hputfont16nx16m(int px, int py, void far *font,
                             int forecolor, int backcolor);
void far EGA_hputfont16nx16m(int px, int py, void far *font,
                             int forecolor, int backcolor);
void far VGA_hputfont16nx16m(int px, int py, void far *font,
                             int forecolor, int backcolor);
void far HIC_hputfont16nx16m(int px, int py, void far *font,
                             int forecolor, int backcolor);

void far HGC_hputORfont8nx16m(int px, int py, void far *font, int color);
void far EGA_hputORfont8nx16m(int px, int py, void far *font, int color);
void far VGA_hputORfont8nx16m(int px, int py, void far *font, int color);
void far HIC_hputORfont8nx16m(int px, int py, void far *font, int color);

void far HGC_hputORfont16nx16m(int px, int py, void far *font, int color);
void far EGA_hputORfont16nx16m(int px, int py, void far *font, int color);
void far VGA_hputORfont16nx16m(int px, int py, void far *font, int color);
void far HIC_hputORfont16nx16m(int px, int py, void far *font, int color);

void far HGC_hclrscr(int px, int py, int width, int height, int color);
void far EGA_hclrscr(int px, int py, int width, int height, int color);
void far VGA_hclrscr(int px, int py, int width, int height, int color);
void far HIC_hclrscr(int px, int py, int width, int height, int color);

void far HGC_hscroll(int px, int py, int width, int height, int line);
void far HGC_hbackscroll(int px, int py, int width, int height, int line);
void far EGA_hscroll(int px, int py, int width, int height, int line);
void far EGA_hbackscroll(int px, int py, int width, int height, int line);
void far VGA_hscroll(int px, int py, int width, int height, int line);
void far VGA_hbackscroll(int px, int py, int width, int height, int line);
void far HIC_hscroll(int px, int py, int width, int height, int line);
void far HIC_hbackscroll(int px, int py, int width, int height, int line);

void far HGC_hgetimage(int px, int py, int width, int height,
                       void far *destin);
void far HGC_hputimage(int px, int py, int width, int height,
                       void far *source);
void far EGA_hgetimage(int px, int py, int width, int height,
                       void far *destin);
void far EGA_hputimage(int px, int py, int width, int height,
                       void far *source);
void far VGA_hgetimage(int px, int py, int width, int height,
                       void far *destin);
void far VGA_hputimage(int px, int py, int width, int height,
                       void far *source);
void far HIC_hgetimage(int px, int py, int width, int height,
                       void far *destin);
void far HIC_hputimage(int px, int py, int width, int height,
                       void far *source);

int  far HGC_hgetpixel(int px, int py);
void far HGC_hputpixel(int px, int py, int color);
int  far EGA_hgetpixel(int px, int py);
void far EGA_hputpixel(int px, int py, int color);
int  far VGA_hgetpixel(int px, int py);
void far VGA_hputpixel(int px, int py, int color);
int  far HIC_hgetpixel(int px, int py);
void far HIC_hputpixel(int px, int py, int color);

void far HGC_hhline(int px, int py, int length, int color);
void far HGC_hvline(int px, int py, int length, int color);
void far EGA_hhline(int px, int py, int length, int color);
void far EGA_hvline(int px, int py, int length, int color);
void far VGA_hhline(int px, int py, int length, int color);
void far VGA_hvline(int px, int py, int length, int color);
void far HIC_hhline(int px, int py, int length, int color);
void far HIC_hvline(int px, int py, int length, int color);

void far HGC_hputsprite(int px, int py, int width, int height,
                        void far *shape, void far *bitmask);
void far EGA_hputsprite(int px, int py, int width, int height,
                        void far *shape, void far *bitmask);
void far VGA_hputsprite(int px, int py, int width, int height,
                        void far *shape, void far *bitmask);
void far HIC_hputsprite(int px, int py, int width, int height,
                        void far *shape, void far *bitmask);

#ifdef __cplusplus
}
#endif

#endif
