/*
 *      File HANDETEC.H
 *      A Header for Detecting Video Boards
 *      '92.2.5
 *      '93.3.11, 7.13, 10.22
 *      Written by Lim, I.K.
 */


#ifndef _HANDETEC_H_
#define _HANDETEC_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Type definitions *******************************************************/

/* Information on Super VGA */

#ifndef SVGAINFO_T
    #define SVGAINFO_T
    #ifdef __cplusplus
        #define _CONST
    #else
        #define _CONST const
    #endif
    typedef struct _svgainfo_t {
        _CONST int ID;   /* ID of Super VGA families                 */
        int biosID;      /* ID of detected Super VGA BIOS            */
        int chipID;      /* ID of detected Super VGA chips           */
        size_t memsize;  /* Detected on-board memory size in K bytes */
        bool rwbank;     /* R/W Dual Bank supported                  */
        bool (far *_CONST detectsvga)(void);
        byte (far *_CONST getmodenum)(int mode);
        bool (far *_CONST checkmemsize)(int mode);
        int  (far *_CONST setmode)(int mode);
        word (far *_CONST setbank)(void);
        struct _svgainfo_t far *nextinfo;
    } svgainfo_t;
#endif

#if !defined(__GRAPHX_DEF_) && !defined(__GRAPHICS_H)
    enum graphics_drivers {
        DETECT,
        CGA, MCGA, EGA, EGA64, EGAMONO, IBM8514,
        HERCMONO, ATT400, VGA, PC3270,
        CURRENT_DRIVER = -1
    };
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Autodetect graphics drivers */

int  far _detectgraph(void);  /* Autodetect HGC/EGA/Standard VGA  */
bool far _detecthgc(void);    /* Autodetect HGC                   */

svgainfo_t far *far detectsvga(void);   /* Autodetect Super VGAs          */
svgainfo_t far *far detecthicol(void);  /* Autodetect Hi-Color Super VGAs */

/* Miscellaneos */

int far farmemcmp(const void far *s1, const void far *s2, size_t n);

#ifdef __cplusplus
}
#endif


/** External variables *****************************************************/

/* If graphics adapter is EGA, true. Otherwise false */

extern bool _isega;

#endif
