/*
 *      File HANCOORD.H
 *      Coordinates and Output Windows
 *      '92.1.9, 2.5, 3.9, 4.24-25, 5.10-11
 *      '93.8.4
 *      Written by Lim, I.K.
 */


#ifndef _HANCOORD_H_
#define _HANCOORD_H_

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Macro constant *********************************************************/

#ifndef DEFWIN
    #define DEFWIN (&_defwin)  /* A pointer to the default window */
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Set text/graphics coordinates in the current window */

void hgotoxy(int x, int y);
void hgotopxy(int px, int py);

/* Set a output window */

void hwindow(int left, int top, int right, int bottom);
void hwindowpxy(int left, int top, int right, int bottom);

/* Set a temporary output window */

int htempwindow(int left, int top, int right, int bottom);
int htempwindowpxy(int left, int top, int right, int bottom);
int hlastwindow(void);

/* Set a specified output window */

int hsetwindow(window_t *win, int left, int top, int right, int bottom,
               int forecolor, int backcolor, window_t *defwin);
int hsetwindowpxy(window_t *win, int left, int top, int right, int bottom,
                  int forecolor, int backcolor, window_t *defwin);

/* Set the current output window to a specified output window */

void hsetcurwindow(window_t *win);

int htempcurwindow(window_t *win);
int hlastcurwindow(void);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Coordinates conversion */

/* text -> graphics */

#define x2px(x) (((x) - 1) * _CW->charspace)
#define y2py(y) (((y) - 1) * _CW->linespace)

/* graphics -> text */

#define px2x(px) ((px) / _CW->charspace + 1)
#define py2y(py) ((py) / _CW->linespace + 1)

/* absolute text -> absolute graphics */

#define ax2apx(ax) (((ax) - 1) * _FW->charspace)
#define ay2apy(ay) (((ay) - 1) * _FW->linespace)

/* absolute graphics -> absolute text */

#define apx2ax(apx) ((apx) / _FW->charspace + 1)
#define apy2ay(apy) ((apy) / _FW->linespace + 1)

/* graphics -> absolute graphics */

#define px2apx(px) (_CW->left + (px))
#define py2apy(py) (_CW->top + (py))

/* absolute graphics -> graphics */

#define apx2px(apx) ((apx) - _CW->left)
#define apy2py(apy) ((apy) - _CW->top)

/* text -> absolute graphics */

#define x2apx(x) px2apx(x2px(x))
#define y2apy(y) py2apy(y2py(y))

/* absolute graphics -> text */

#define apx2x(apx) px2x(apx2px(apx))
#define apy2y(apy) py2y(apy2py(apy))

/* text -> absolute text */

#define x2ax(x) apx2ax(x2apx(x))
#define y2ay(y) apy2ay(y2apy(y))

/* absolute text -> text */

#define ax2x(ax) apx2x(ax2apx(ax))
#define ay2y(ay) apy2y(ay2apy(ay))

/* absolute text -> graphics */

#define ax2px(ax) apx2px(ax2apx(ax))
#define ay2py(ay) apy2py(ay2apy(ay))

/* graphics -> absolute text */

#define px2ax(px) apx2ax(px2apx(px))
#define py2ay(py) apy2ay(py2apy(py))

/* Get the current text coordinates in the current window */

#define hwherex() apx2x(_CW->apx)
#define hwherey() apy2y(_CW->apy)

/* Get the current graphics coordinates in the current window */

#define hgetpx() apx2px(_CW->apx)
#define hgetpy() apy2py(_CW->apy)

/* Get the maximum values of coordinates */

#define hgetmaxx() (_CW->width / _CW->charspace)
#define hgetmaxy() (_CW->height / _CW->linespace)

#define hgetmaxpx() (_CW->width - 1)
#define hgetmaxpy() (_CW->height - 1)

#define hgetmaxax() apx2ax(_pxmax)
#define hgetmaxay() apy2ay(_pymax)

#define hgetmaxapx() _pxmax
#define hgetmaxapy() _pymax

/* Get size of current or fullscreen window */

#define hgetwidth() (_CW->width / _CW->charspace)
#define hgetheight() (_CW->height / _CW->linespace)

#define hgetpwidth() (_CW->width)
#define hgetpheight() (_CW->height)

#define hgetawidth() apx2ax(_pxmax)
#define hgetaheight() apy2ay(_pymax)

#define hgetapwidth() (_pxmax + 1)
#define hgetapheight() (_pymax + 1)


/** External variables *****************************************************/

/* A pointer to the current output window */
/* The default is &_defwin                */

extern window_t *_CW;

/* A pointer to the fullscreen output window */
/* The default is &_fullscrwin               */

extern window_t *_FW;

/* The default output window */

extern window_t _defwin;

/* The fullscreen output window */

extern window_t _fullscrwin;

/* _maxtempwindowlevel defines the maximum nest level */
/* for calling htempwindow                            */
/* This variable must be set                          */
/* before first calling of the htempwindow function   */
/* The default is 4                                   */
/* _tempwindowlevel is the current nest level         */

extern int _maxtempwindowlevel;
extern int _tempwindowlevel;

/* _maxtempcurwindowlevel defines the maximum nest level */
/* for calling htempcurwindow                            */
/* This variable must be set                             */
/* before first calling of the htempcurwindow function   */
/* The default is 10                                     */
/* _tempcurwindowlevel is the current nest level         */

extern int _maxtempcurwindowlevel;
extern int _tempcurwindowlevel;

/* Point the current sprite window structure for hputsprite */
/* The default is a pointer to _fullscrwin                  */

extern window_t far *_sprwinp;

/* Screen boundaries in the FULL screen (not in the current window) */

extern const int _homepx, _homepy, _pxmax, _pymax, _pxwidth, _pyheight;

#endif
