/*
 *      File HANCOLOR.H
 *      Colors
 *      '92.2.5, 5.10, 9.13
 *      Written by Lim, I.K.
 */


#ifndef _HANCOLOR_H_
#define _HANCOLOR_H_

#ifndef _HANTYPES_H_
    #include "hantypes.h"
#endif


/** Macro constants ********************************************************/

/* Hangul standard colors */

#define HBLACK        _colormap[BLACK]
#define HBLUE         _colormap[BLUE]
#define HGREEN        _colormap[GREEN]
#define HCYAN         _colormap[CYAN]
#define HRED          _colormap[RED]
#define HMAGENTA      _colormap[MAGENTA]
#define HBROWN        _colormap[BROWN]
#define HLIGHTGRAY    _colormap[LIGHTGRAY]
#define HDARKGRAY     _colormap[DARKGRAY]
#define HLIGHTBLUE    _colormap[LIGHTBLUE]
#define HLIGHTGREEN   _colormap[LIGHTGREEN]
#define HLIGHTCYAN    _colormap[LIGHTCYAN]
#define HLIGHTRED     _colormap[LIGHTRED]
#define HLIGHTMAGENTA _colormap[LIGHTMAGENTA]
#define HYELLOW       _colormap[YELLOW]
#define HWHITE        _colormap[WHITE]

/* MS-Windows compatible colors */

#define WBLACK      _wcolormap[0]
#define WDARKRED    _wcolormap[1]
#define WDARKGREEN  _wcolormap[2]
#define WGOLDGREEN  _wcolormap[3]
#define WDARKBLUE   _wcolormap[4]
#define WPURPLE     _wcolormap[5]
#define WBLUEGRAY   _wcolormap[6]
#define WDARKGRAY   _wcolormap[7]
#define WLIGHTGRAY  _wcolormap[8]
#define WLIGHTRED   _wcolormap[9]
#define WLIGHTGREEN _wcolormap[10]
#define WYELLOW     _wcolormap[11]
#define WLIGHTBLUE  _wcolormap[12]
#define WMAGENTA    _wcolormap[13]
#define WCYAN       _wcolormap[14]
#define WWHITE      _wcolormap[15]

#define MAXMONOCOLOR 0x01
#define MAXLOCOLOR   0x0f
#define MAXMIDCOLOR  0xff
#define MAXHICOLOR   0x7fff


/** Type definitions *******************************************************/

#ifndef __COLORS
    #define __COLORS
    enum COLORS {
        BLACK,         /* dark colors */
        BLUE,
        GREEN,
        CYAN,
        RED,
        MAGENTA,
        BROWN,
        LIGHTGRAY,
        DARKGRAY,      /* light colors */
        LIGHTBLUE,
        LIGHTGREEN,
        LIGHTCYAN,
        LIGHTRED,
        LIGHTMAGENTA,
        YELLOW,
        WHITE,
    };
#endif

#ifndef MAXCOLORS
    #define MAXCOLORS 15
#endif

/* Hi-Colors */

enum hicolor_t {              /*   Red   Green   Blue */
    HIBLACK        = 0x0000,  /*   0.0%   0.0%   0.0% */
    HIBLUE         = 0x0015,  /*   0.0%   0.0%  66.7% */
    HIGREEN        = 0x02a0,  /*   0.0%  66.7%   0.0% */
    HICYAN         = 0x02b5,  /*   0.0%  66.7%  66.7% */
    HIRED          = 0x5400,  /*  66.7%   0.0%   0.0% */
    HIMAGENTA      = 0x5415,  /*  66.7%   0.0%  66.7% */
    HIBROWN        = 0x5540,  /*  66.7%  33.3%   0.0% */
    HILIGHTGRAY    = 0x56b5,  /*  66.7%  66.7%  66.7% */
    HIDARKGRAY     = 0x294a,  /*  33.3%  33.3%  33.3% */
    HILIGHTBLUE    = 0x295f,  /*  33.3%  33.3% 100.0% */
    HILIGHTGREEN   = 0x2bea,  /*  33.3% 100.0%  33.3% */
    HILIGHTCYAN    = 0x2bff,  /*  33.3% 100.0% 100.0% */
    HILIGHTRED     = 0x7d4a,  /* 100.0%  33.3%  33.3% */
    HILIGHTMAGENTA = 0x7d5f,  /* 100.0%  33.3% 100.0% */
    HIYELLOW       = 0x7fea,  /* 100.0% 100.0%  33.3% */
    HIWHITE        = 0x7fff,  /* 100.0% 100.0% 100.0% */
};

typedef byte rgbpalette_t[3];

enum rgb_t {RGB_RED, RGB_GREEN, RGB_BLUE};


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Set the color map */

void hsetallcolormap(void);
void hsetcolormap(int colornum, int value);

/* Set/get EGA palettes (EGA/VGA/SVGA 16 color modes only) */

void hsetpalette(int colornum, int color);
void hresetpalette(void);

int hgetpalette(int colornum);  /* VGA only */

/* Set/get indivisual RGB palettes (VGA/SVGA 16/256 color modes only) */

void hsetrgbpalette(int colornum, const rgbpalette_t palette);
void hgetrgbpalette(int colornum, rgbpalette_t palette);

/* Set/get individual RGB palettes (VGA/SVGA 256 color modes only) */

void hsetallrgbpalette(int first, int number, const rgbpalette_t palettes[]);
void hgetallrgbpalette(int first, int number, rgbpalette_t palettes[]);

/* Set MS-Windows compatible RGB palettes (VGA/SVGA 16/256 color modes only) */

void hsetwindowspalette(int first);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

/* Set the current foreground and background colors */

#define hsetcolor(color)   (_CW->forecolor = (color))
#define hsetbkcolor(color) (_CW->backcolor = (color))

/* Get the current foreground and background colors */

#define hgetcolor()   (_CW->forecolor)
#define hgetbkcolor() (_CW->backcolor)

/* Get the maximum value of colors in the current Hangul mode */

#define hgetmaxcolor() _hmaxcolor

/* Convert 24 bit True-Color RGB values to 15 bit Hi-Color values */

#define hicolor(r, g, b) ((int)((((byte)(r) >> 3) << 10) \
                         | (((byte)(g) >> 3) << 5) | ((byte)(b) >> 3)))


/** External variables *****************************************************/

/* A pointer to the current output window */

extern window_t *_CW;

/* The maximum value of colors */

extern const int _hmaxcolor;

/* The color map used to make video-mode-independent programs */
/* Refer to the setallcolormap and setcolormap functions      */
/* The default is for 16/256 color modes                      */

extern int _colormap[];

/* MS-Windows compatible color map */

extern int _wcolormap[];

#endif
