/*
 *      File HANCODE.H
 *      A Header for Hangul Code
 *      '92.5.24
 *      Written by Lim, I.K.
 */


#ifndef _HANCODE_H_
#define _HANCODE_H_

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif


/** Macro constants ********************************************************/

#define FC 0    /* Fill Code */
#define NC 255  /* No Code   */

#ifndef INITIAL
    #define INITIAL 0
    #define MEDIAL  1
    #define FINAL   2
#endif


/** External variables *****************************************************/

/* A pointer to the current Hangul code table */

extern const byte (*_codeindex)[32];

/* A index table for the common combined Hangul code */

extern const byte _commoncodeindex[3][32];

#endif
