/*
 *      File HANBGI.H
 *      A Header for Hangul BGI Interface Library
 *      '92.1.1-2,4,6, 2.5
 *      '93.4.23
 *      Written by Lim, I.K.
 */


#ifndef _HANBGI_H_
#define _HANBGI_H_

#ifndef _CHKVER_H_
    #include "chkver.h"
#endif

#ifndef _TYPEDEFS_H_
    #include "typedefs.h"
#endif

#ifndef __TURBOC__
    #error Compile ONLY with Turbo C 2.0, Turbo C++ 1.0 or Borland C++ 2.0
#endif

#ifdef _HANDETEC_H_
    #error Do not include "handetec.h", it will be included by "hanbgi.h"
#endif

#ifdef _HANOUT_H_
    #error Include "hanbgi.h" before "hanout.h" or "hanlib.h"
#endif

#if defined(__GRAPHX_DEF_) || defined(__GRAPHICS_H)
    #error Do not include <graphics.h>, it will be included by "hanbgi.h"
#endif

#include <graphics.h>
#include "handetec.h"


/** Macro constant *********************************************************/

#ifndef EXIT_FAILURE
    #define EXIT_FAILURE 1
#endif


/** Function declarations **************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* BGI interface */

void _arc(int x, int y, int stangle, int endangle, int radius);
void _bar(int left, int top, int right, int bottom);
void _bar3d(int left, int top, int right, int bottom, int depth, int topflag);
void _circle(int x, int y, int radius);
void _cleardevice(void);
void _clearviewport(void);
void _drawpoly(int numpoints, int far *polypoints);
void _ellipse(int x, int y, int stangle, int endangle,
         int xradius, int yradius);
void _fillellipse(int x, int y, int xradius, int yradius);
void _fillpoly(int numpoints, int far *polypoints);
void _floodfill(int x, int y, int border);
int  _getbkcolor(void);
int  _getcolor(void);
void _getfillsettings(struct fillsettingstype far *fillinfo);
void _getimage(int left, int top, int right, int bottom, void far *bitmap);
int  _getpixel(int x, int y);
void _graphdefaults(void);
unsigned _imagesize(int left, int top, int right, int bottom);
void _line(int x1, int y1, int x2, int y2);
void _linerel(int dx, int dy);
void _lineto(int x, int y);
void _outtext(char far *textstring);
void _outtextxy(int x, int y, char far *textstring);
void _pieslice(int x, int y, int stangle, int endangle, int radius);
void _putimage(int left, int top, void far *bitmap, int op);
void _putpixel(int x, int y, int color);
void _rectangle(int left, int top, int right, int bottom);
void _sector(int x, int y, int stangle, int endangle,
             int xradius, int yradius);
void _setbkcolor(int color);
void _setcolor(int color);
void _setfillpattern(char far *upattern, int color);
void _setfillstyle(int pattern, int color);
void _setviewport(int left, int top, int right, int bottom, int clip);

/* Convert BGI modes to Hangul modes */

int _gethanmode(int graphdriver, int graphmode);

/* Mouse interface */

int mou__BGIentry(int x1, int y1, int x2, int y2);
int mou__exit(void);

/* Miscellaneos */

int  gprintf(const char *format, ...);
int  gprintfpxy(int px, int py, const char *format, ...);
void drawborder(int bordercolor);

#ifdef __cplusplus
}
#endif


/** Macro functions ********************************************************/

#ifndef NOBGIREPLACE

#define arc(x, y, stangle, endangle, radius) \
        _arc(x, y, stangle, endangle, radius)
#define bar(left, top, right, bottom) _bar(left, top, right, bottom)
#define bar3d(left, top, right, bottom, depth, topflag) \
        _bar3d(left, top, right, bottom, depth, topflag)
#define circle(x, y, radius) _circle(x, y, radius)
#define cleardevice() _cleardevice()
#define clearviewport() _clearviewport()
#define closegraph() (hrestorecrtmode(), closegraph())
#define drawpoly(numpoints, polypoints) _drawpoly(numpoints, polypoints)
#define ellipse(x, y, stangle, endangle, xradius, yradius) \
        _ellipse(x, y, stangle, endangle, xradius, yradius)
#define fillellipse(x, y, xradius, yradius) \
        _fillellipse(x, y, xradius, yradius)
#define fillpoly(numpoints, polypoints) \
        _fillpoly(numpoints, polypoints)
#define floodfill(x, y, border) _floodfill(x, y, border)
#define getbkcolor() _getbkcolor()
#define getcolor() _getcolor()
#define getimage(left, top, right, bottom, bitmap) \
        _getimage(left, top, right, bottom, bitmap)
#define getpixel(x, y) _getpixel(x, y)
#define graphdefaults() _graphdefaults()
#define imagesize(left, top, right, bottom) \
        _imagesize(left, top, right, bottom)
#define installuserdriver(name, detect) \
        puterr("User cannot call installuserdriver", EXIT_FAILURE)
#define line(x1, y1, x2, y2) _line(x1, y1, x2, y2)
#define linerel(dx, dy) _linerel(dx, dy)
#define lineto(x, y) _lineto(x, y)
#define outtext(textstring) _outtext(textstring)
#define outtextxy(x, y, textstring) _outtextxy(x, y, textstring)
#define pieslice(x, y, stangle, endangle, radius) \
        _pieslice(x, y, stangle, endangle, radius)
#define putimage(left, top, bitmap, op) _putimage(left, top, bitmap, op)
#define putpixel(x, y, color) _putpixel(x, y, color)
#define rectangle(left, top, right, bottom) \
        _rectangle(left, top, right, bottom)
#define registerbgidriver(driver) \
        puterr("User cannot call registerbgidriver", EXIT_FAILURE)
#define registerfarbgidriver(driver) \
        puterr("User cannot call registerfarbgidriver", EXIT_FAILURE)
#define restorecrtmode() hrestorecrtmode()
#define sector(x, y, stangle, endangle, xradius, yradius) \
        _sector(x, y, stangle, endangle, xradius, yradius)
#define setbkcolor(color) _setbkcolor(color)
#define setcolor(color) _setcolor(color)
#define setgraphmode(mode) hsetgraphmode()
#define setfillpattern(upattern, color) _setfillpattern(upattern, color)
#define setfillstyle(pattern, color) _setfillstyle(pattern, color)
#define setviewport(left, top, right, bottom, clip) \
        _setviewport(left, top, right, bottom, clip)

#endif

/* For BGI interface */

#define BGI(func) (_BGIentry(), func, _BGIexit())

/* For Mouse interface */

#define mou_BGIentry(x1, y1, x2, y2) \
        ((_mouhiddenlevel == 0) ? mou__BGIentry(x1, y1, x2, y2) : 0)
#define mou_BGIexit() ((_mouhiddenlevel == 0) ? mou__exit() : 0)


/** External variables *****************************************************/

/* The path to the BGI drivers, if needed, in BGI Mode */
/* The default is "", ie. the current directory        */

extern char *_pathtodriver;

/* Entry and exit functions for the BGI functions */

extern void (*_BGIentry)(void);
extern void (*_BGIexit)(void);

/* Set by imagesize macro function                                   */
/* If the byte size of a image is greater or equal than 65535,       */
/* the return value of imagesize will be 65535                       */
/* Even if that case, _bgiimagesize will ALWAYS have a correct value */

extern long _bgiimagesize;

#endif
