/*
 *      File CHKVER.H
 *      Check Compiler Version
 *      '92.2.5
 *      Written by Lim, I.K.
 */


#ifndef _CHKVER_H_
#define _CHKVER_H_

#ifdef __TURBOC__

/* Check Turbo C version */

#if __TURBOC__ != 0x018d && __TURBOC__ < 0x0200
    #error Compile with Turbo C 2.0, Turbo C++ 1.0, Borland C++ 2.0 or later
#endif

/* Check memory model */

#ifdef __TINY__
    #error Do not compile with the tiny model!
#endif

#ifdef __HUGE__
    #error Do not compile with the huge model!
#endif

/* Enable some warnings */

#pragma warn +amp  /* "Superfluous & with function or array"        On  */
#pragma warn +rvl  /* "Function should return a value"              On  */
#pragma warn +sig  /* "Conversion may lose significant digits"      On  */
#pragma warn +use  /* "Declared but never used"                     On  */
#pragma warn +pro  /* "Call to function with no prototype"          On  */

/* Disable a warning */

#pragma warn -ucp  /* "Mixing pointers to signed and unsigend char" Off */

#endif

#endif
