/*
 *      File S800TEST.C
 *      Super VGA & VESA BIOS Tester for 800x600x16 Mode
 *      Written by Lim, I.K.
 */


#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>

#include "extkey.h"
#include "hanlib.h"
#include "hansvga.h"


svgainfo_t far *svga;

char *svgachip[] = {
    "Unknown", "VESA", "ET3000", "ET4000", "18800", "18800-1", "28800",
    "TVGA8800BR", "TVGA8800CS", "TVGA8900C", "PVGA1A", "WD90C00", "WD90C10",
    "WD90C11", "WD90C30", "WD90C31", "M3121", "OTI067", "AVGA2",
    "CL-GD510/520", "CL-GD610/620",
    "CL-GD5420", "CL-GD5422", "CL-GD5424", "CL-GD5426",
};
char *svgabios[] = {
    "Unknown", "VESA", "TSENG LABS", "ATI", "TRIDENT", "WDC", "ACER",
    "OTI", "ACUMOS", "GENOA", "EVEREX",
    "CIRRUS", "Eagle II VGA BIOS", "CIRRUS2",
};
char *modename[] = {
    "HANSVGA640HI", "HANSVGA800LO", "HANSVGA800HI",
    "HANSVGA1024LO", "HANSVGA1024HI",
};
bool vesatest = false;


bool far dummy(void)
{
    return false;
}

word m(byte modenum)
{
    if (modenum == 0) return 0;
    if (svga->ID == SVGA_VESA) return (0x100 | modenum);
    else return modenum;
}

void detect_board(void)
{
    clrscr();

    LINK_SVGA_all();
    svga = detectsvga();

    if (svga == NULL) {
        if (!vesatest) cprintf("No Super VGA board detected!");
        else cprintf("No VESA driver detected!");
        exit(1);
    }

    highvideo();
    cprintf("Super VGA & VESA BIOS Tester V%d for 800x600x16 Mode\r\n\n",
            SVGACHIP_USER - 1);
    normvideo();

    cprintf("Chip detected          ");
    highvideo();
    cprintf("%s\r\n", svgachip[svga->chipID]);
    normvideo();
    cprintf("BIOS detected          ");
    highvideo();
    cprintf("%s\r\n", svgabios[svga->biosID]);
    normvideo();
    cprintf("Memory size detected   ");
    highvideo();
    if (svga->memsize == 0) cprintf("Unknown\r\n");
    else cprintf("%dK bytes\r\n", svga->memsize);
    normvideo();
    cprintf("R/W Dual Bank support  ");
    highvideo();
    cprintf("%s\r\n", svga->rwbank ? "Yes" : "No");
    normvideo();

    cprintf("\r\nMode numbers (FF = Not supported)\r\n");
    cprintf("HANSVGA640HI  [%3X]          \r\n", m(svga->getmodenum(0)));
    cprintf("HANSVGA800LO  [%3X] <- F2 key\r\n", m(svga->getmodenum(1)));
    cprintf("HANSVGA800HI  [%3X]          \r\n", m(svga->getmodenum(2)));
    cprintf("HANSVGA1024LO [%3X]          \r\n", m(svga->getmodenum(3)));
    cprintf("HANSVGA1024HI [%3X]          \r\n", m(svga->getmodenum(4)));
}

void test_mode(int hanhiresmode, int c)
{
    int i, px, py, x0, y0;

    if (svga->getmodenum(hanhiresmode) == 0xff) {
        cprintf("%s mode is not supported by this chip!\r\n", modename[hanhiresmode]);
        cprintf("Press any key...");
        pause();
        return;
    }

    if (!svga->checkmemsize(hanhiresmode)) {
        cprintf("Insufficient memory(VRAM) to support specified graphics mode!\r\n");
        cprintf("Press any key...");
        pause();
        return;
    }

    switch (c) {
    case F2:
        inithanlib(HIRESSTDMODE, HANSVGA800LO, DEFHANFONT, DEFENGFONT);
        break;
    default:
        return;
    }
    if (hgraphresult() < NOERROR) {
        cprintf("Graphics mode initialization error!\r\n");
        cprintf("SVGA BIOS does not support %s mode.\r\n", modename[hanhiresmode]);
        cprintf("Maybe because of insufficient memory(VRAM) or improper RAMDAC for this mode.\r\n");
        cprintf("Press any key...");
        pause();
        return;
    }

    for (i = 0; i <= hgetmaxcolor(); i++) {
        px = i % 16 * hgetpwidth() / 16;
        py = i / 16 * hgetpheight() / 16;
        hsolidbarpxy(px, py, -(hgetpwidth() / 16),
                     -(hgetpheight() / ((hgetmaxcolor() + 1) / 16)), i);
    }

    hhline(0, 0, hgetpwidth(), LIGHTRED);
    hvline(0, 0, hgetpheight(), LIGHTRED);
    hvline(hgetmaxpx(), 0, hgetpheight(), LIGHTRED);
    hhline(0, hgetmaxpy(), hgetpwidth(), LIGHTRED);

    hwindowpxy(hgetmaxpx() * 1 / 4, hgetmaxpy() * 2 / 5,
               hgetmaxpx() * 3 / 4, hgetmaxpy() * 3 / 5);
    hsetbkcolor(YELLOW);
    hsetcolor(BLACK);
    hclrscr();

    hsettextjustify(CENTER_TEXT);
    x0 = (hgetmaxx() + 1) / 2;
    y0 = (hgetmaxy() + 1) / 2 - 1;
    hprintfxy(x0, y0, "aϢ a %s", modename[hanhiresmode]);
    hprintfxy(x0, y0 + 1, "a ѡ %02XH",
              _cursvgainfo->getmodenum(hanhiresmode));
    hprintfxy(x0, y0 + 2, "Ёw&w %dx%dx%d",
              hgetapwidth(), hgetapheight(), hgetmaxcolor() + 1);

    hprintfxy(x0, y0 + 3, "a iAa aAa...");

    pause();

    closehan();
}

void quit(void)
{
    cprintf("Super VGA & VESA BIOS Tester V%d for 800x600x16 Mode\r\n\n"
            "Usage: s800test [/s|/v]\r\n"
            "Options: /s  Super VGA test by direct I/O port access\r\n"
            "         /v  Super VGA test via VESA BIOS\r\n",
            SVGACHIP_USER - 1);
    exit(1);
}

void main(int argc, char *argv[])
{
    int c;
    int hanmode;

    if (argc != 2 || argv[1][0] != '/') quit();
    argv[1][1] = tolower(argv[1][1]);
    if (argv[1][1] != 's' && argv[1][1] != 'v') quit();

    if (argv[1][1] == 'v') {
        LINK_SVGA_all();
        svga = _svgainfolist;
        while (svga != NULL) {
            if (svga->ID != SVGA_VESA) (void far *)svga->detectsvga = dummy;
            svga = svga->nextinfo;
        }
        vesatest = true;
    }

    for (; ; ) {
        detect_board();

        cprintf("\r\nPress <F2> key to select a graphics mode "
                "or any other key to quit...");

        switch (c = getxch()) {
        default:
            return;
        case F2:
            hanmode = HANSVGA800LO;
            break;
        }
        cprintf("\r\n\n");

        test_mode(hanmode - HANSVGA640HI, c);
    }
}
