/* File EX_WCOL.C: Shows MS-Windows compatible colors */

#include "hanlib.h"

void main(void)
{
    int x;

    /* Initialize the library, HANVGA mode */

    inithanlib(STDMODE, HANVGA, HAN8GD1, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program requires VGA or compatibles!", 1);

    /* Standard colors */

    hsettextjustify(CENTER_TEXT);

    hprintfxy(hgetmaxx() / 2, 1, "a w");

    for (x = 1; x < 80; x += 5)
        hsolidbar(x + 1, 3, x + 4, 29, (x - 1) / 5);

    /* Wait for a key */

    pause();

    /* MS-Windows compatible colors */

    hprintfxy(hgetmaxx() / 2, 1, "啡a ѡ w");
    hsetwindowspalette(0);

    /* Wait for a key */

    pause();
}
