/* File EX_TWIN.C: An example of the htempwindow function */

#include "hanlib.h"

void main(void)
{
    int i;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, NULL, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i % 2);

    /* Print usage */

    hgotoxy(1, 24);
    hprintf("Temporary window test\n");
    hprintf("Conventional output window version, "
            "compare source code with EX_TCWIN.C\n");

    /* The default window - background */

    hwindow(1, 1, -80, -4);
    hsetcolor(HWHITE), hsetbkcolor(HDARKGRAY);
    hclrscr();
    hputs("Default window\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    pause();

    /* Set 1st level */

    htempwindow(1, 5, -80, -4);
    hsetbkcolor(HBLUE);
    hclrscr();
    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HBLUE);
    hputs("Temporary window 1\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    hsetreverse(false);
    pause();

    /* Set 2nd level */

    htempwindow(1, 9, -80, -4);
    hsetcolor(HWHITE), hsetbkcolor(HRED);
    hclrscr();
    hputs("Temporary window 2\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    pause();

    /* Set 3rd level */

    htempwindow(1, 13, -80, -4);
    hsetbkcolor(HCYAN);
    hclrscr();
    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HCYAN);
    hputs("Temporary window 3\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    hsetreverse(false);
    pause();

    /* Return to the 2nd level */

    hlastwindow();
    hsetcolor(HWHITE), hsetbkcolor(HRED);
    hputs("Temporary window 3 was released\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    pause();

    /* Return to the 1st level */

    hlastwindow();
    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HBLUE);
    hputs("Temporary window 2 was released\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    hsetreverse(false);
    pause();

    /* Release final temporary window */

    hlastwindow();
    hsetbkcolor(HDARKGRAY);
    hputs("Temporary window 1 was released\n");
    hprintf("Nested level: %d\n", _tempwindowlevel);
    pause();
}
