/* File EX_TPAD.C: An example of the htinypad function */

#include <alloc.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>

#include "ascii.h"
#include "extkey.h"
#include "hanin.h"
#include "hanlib.h"
#include "hanwout.h"

window_t usagewin, resultwin, statuswin;
tpadinfo_t tpad;
int cursorcolor;

void define_windows(void)
{
    /* Usage window */

    hsetwindow(&usagewin, 1, 13, 80, 24, HWHITE, HDARKGRAY, DEFWIN);
    wregisterhanfont(&usagewin, HAN8GD1);

    /* Result window */

    hsetwindow(&resultwin, 1, 13, 80, 24, HWHITE, HDARKGRAY, DEFWIN);

    /* Status window */

    hsetwindow(&statuswin, 1, 25, 80, 25, HWHITE, HBLACK, &usagewin);
    wsetreverse(&statuswin, true);
}

void print_usage(void)
{
    htempcurwindow(&usagewin);

    hclrscr();

    hsetreverse(true);
    hputsxy( 1, 1, " aw e iA ");
    hsetreverse(false);
    hputsxy( 1, 2, "<Alt-X>       : b a");
    hputsxy( 1, 3, "<Enter>       : З/З ");
    hputsxy( 1, 4, "<Shift-Space> : ei/w ");
    hputsxy( 1, 5, "<Ins>         : s/ ");
    hputsxy( 1, 6, "<Left>        :  e e ");
    hputsxy( 1, 7, "<Right>       :  e e ");
    hputsxy( 1, 8, "<Ctrl-Left>   :  e e ");
    hputsxy( 1, 9, "<Ctrl-Right>  :  e e ");
    hputsxy(40, 2, "<Home>      : З 喁 ");
    hputsxy(40, 3, "<End>       : З ҁ ");
    hputsxy(40, 4, "<ESC>       : b ᭡");
    hputsxy(40, 5, "<Backspace> : | ia bA/ei a ");
    hputsxy(40, 6, "<Del>       :  á e ia bA");
    hputsxy(40, 7, "<Ctrl-Y>    : A З bA");
    hputsxy(40, 8, "<Ctrl-T>    : e e bA");
    hputsxy(40, 9, "<Ctrl-G>    :  ҁ bA");

    hsetreverse(true);
    hputsxy(1, 10, " awa  iA b  ");
    hsetreverse(false);
    hputsxy(1, 11, "鯢/A鯢 ae :         ) <F8>");
    hputsxy(1, 12, "a b, Ήa w/q:   ) <F9>, <F10>");

    hlastcurwindow();
}

void hookhangulmodetoggle(bool hangulmode)
{
    htempcurwindow(&statuswin);

    hputsxy(1, 1, hangulmode ? " ei Գ" : " w Գ");
    if (hangulmode) hsetbufcursor(FRAMECURSOR, FRAMECURSOR, cursorcolor);
    else hsetbufcursor(UNDERCURSOR, UNDERCURSOR, cursorcolor);

    hlastcurwindow();
}

void hookinsertmodetoggle(bool insertmode)
{
    htempcurwindow(&statuswin);

    wputsxy(&statuswin, 9, 1, insertmode ? " s Գ" : "  Գ");
    cursorcolor = insertmode ? HRED : HBROWN;
    hsetbufcursor(NULL, NULL, cursorcolor);

    hlastcurwindow();
}

void hookmistyping(void)
{
    sound(1000);
    delay(100);
    nosound();
}

void hookhtinypad(int *keycodep, tpadinfo_t *tpadinfo)
{
    if (tpadinfo != &tpad) return;  /* If other tinypad, return */

    htempcurwindow(&statuswin);

    /* Initialize the status line before any key input */

    if (keycodep == NULL) {
        hputsxy(17, 1, "                        Գ");
        hputsxy(43, 1, " 鯢 Գ");
        hputsxy(53, 1, " a w Գ");
        hputsxy(66, 1, " Ήa w ");
        hlastcurwindow();
    }

    /* Process user-defined keys */

    switch (*keycodep) {
    case F8:
        if (ishan2board()) {
            hsethan390board(issplitmode());
            hputsxy(43, 1, " A鯢 Գ");
        } else {
            hsethan2board(issplitmode());
            hputsxy(43, 1, " 鯢 Գ");
        }
        break;
    case F9:
        _allowmistyping = !_allowmistyping;
        if (_allowmistyping) hputsxy(53, 1, " a w Գ");
        else hputsxy(53, 1, " a q Գ");
        break;
    case F10:
        if (issplitmode()) {
            hputsxy(66, 1, " Ήa q ");
            ishan2board() ? hsethan2board(false) : hsethan390board(false);
        } else {
            hputsxy(66, 1, " Ήa w ");
            ishan2board() ? hsethan2board(true) : hsethan390board(true);
        }
        break;
    }

    hlastcurwindow();
}

void main(void)
{
    byte *buffer;
    int i, size;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Register Hangul Graphics Characters */

    registerhgrfont(HGR1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 15);

    /* Initialize the delay function */

    delay(0);

    /* Define windows */

    define_windows();

    /* Print usage */

    print_usage();

    /* Set cursor shape and color */

    hsetbufcursor(UNDERCURSOR, UNDERCURSOR, cursorcolor = HRED);

    /* Set hook vectors */

    _hookhangulmodetoggle = hookhangulmodetoggle;
    _hookinsertmodetoggle = hookinsertmodetoggle;
    _hookmistyping = hookmistyping;
    _hookhtinypad = hookhtinypad;

    /* Get the size of a tinypad */

    size = hgettinypadsize(1, 1, 80, 12);
    if (size < NOERROR) puterr("Out of range!", 1);

    /* Allocate memory for the input buffer of the tinypad */

    buffer = malloc(size);
    if (buffer == NULL) puterr("Out of memory!", 1);

    /* Define the tinypad */

    hsettinypad(&tpad, buffer, true, true, 1, 1, 80, 12);

    /* Get text with the tinypad */

    _key.delafter = CTRL_G;
    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HMAGENTA);
    htinypad(&tpad);
    hsetreverse(false);

    /* Print text */

    hsetcurwindow(&resultwin);
    for (i = 1; i <= tpad.height; i++)
        hputsxy(1, i, hgettpadln(&tpad, i));

    /* Wait for a key with a cursor blinking */

    hsetcurwindow(&statuswin);
    hsetbkcolor(HRED);
    hgotoxy(17, 1);
    hprintf("a iAa aAa...");
    hsetbufcursor(FRAMECURSOR, FRAMECURSOR, HWHITE);
    _hangulmode = false;
    hgetch();
}
