/* File EX_TCWIN.C: An example of the htempcurwindow function */

#include "hanlib.h"
#include "hanwout.h"

void main(void)
{
    int i;
    window_t win1, win2, win3;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, NULL, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i % 2);

    /* Print usage */

    hgotoxy(1, 24);
    hprintf("Temporary window test\n");
    hprintf("Attribute independent output window version, "
            "compare source code with EX_TWIN.C\n");

    /* Define and clear windows */

    hwindow(1, 1, -80, -4);
    hsetcolor(HWHITE), hsetbkcolor(HDARKGRAY);
    hclrscr();

    hsetwindow(&win1, 1, 5, -80, -4, HWHITE, HBLUE, DEFWIN);
    wclrscr(&win1);
    wsetreverse(&win1, true);
    wsetbkcolor(&win1, HWHITE), wsetcolor(&win1, HBLUE);

    hsetwindow(&win2, 1, 9, -80, -4, HWHITE, HRED, DEFWIN);
    wclrscr(&win2);

    hsetwindow(&win3, 1, 13, -80, -4, HWHITE, HCYAN, DEFWIN);
    wclrscr(&win3);
    wsetreverse(&win3, true);
    wsetbkcolor(&win3, HWHITE), wsetcolor(&win3, HCYAN);

    /* The default window - background */

    hputs("Default window\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Set 1st level */

    htempcurwindow(&win1);
    hputs("Temporary window 1\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Set 2nd level */

    htempcurwindow(&win2);
    hputs("Temporary window 2\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Set 3rd level */

    htempcurwindow(&win3);
    hputs("Temporary window 3\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Return to the 2nd level */

    hlastcurwindow();
    hputs("Temporary window 3 was released\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Return to the 1st level */

    hlastcurwindow();
    hputs("Temporary window 2 was released\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();

    /* Release final temporary window */

    hlastcurwindow();
    hputs("Temporary window 1 was released\n");
    hprintf("Nested level: %d\n", _tempcurwindowlevel);
    pause();
}
