/* File EX_SPRIT.C: An example of the hputsprite function */

#include <alloc.h>

#include "ascii.h"
#include "extkey.h"
#include "hanlib.h"

#include "boxsprit.c"

#define WIDTH  15
#define HEIGHT 15

#define STEP 5

static int lastpx, lastpy;
void far *boxshape, far *scrbuf;

void showsprite(int px, int py)
{
    lastpx = px, lastpy = py;

    hgetimage(lastpx, lastpy, -WIDTH, -HEIGHT, scrbuf);
    hputsprite(px, py, -WIDTH, -HEIGHT, boxshape, boxmask);
}

void hidesprite(void)
{
    hputimage(lastpx, lastpy, scrbuf);
}

void main(void)
{
    int i, c;
    int px, py;
    long size;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, HAN8GD1, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 2 % 2);

    /* Clear the entire screen */

    hsetbkcolor(HBLUE);
    hclrscr();

    /* Draw background image */

    for (py = 32; py <= hgetmaxpy(); py++)
        for (px = 0; px <= hgetmaxpx(); px++)
            hputpixel(px, py, _colormap[(px + py) % 16]);

    /* Print usage */

    hprintfxy(2, 1, "ia iAi  e w be bai"
              " a ...");
    hprintfxy(2, 2, "wi wǡ g bai   sa.");
    hprintfxy(hgetmaxx() - 8, 1, "ESC a");

    /* Allocate memory to move the sprite */

    size = himagesize(0, 0, -WIDTH, -HEIGHT);
    scrbuf = farmalloc(size);
    if (scrbuf == NULL) puterr("Not enough memory", 1);

    /* Select the shape of the box */

    boxshape = (hgetmaxcolor() == MAXCOLORS) ? (void *)boxshape16 :
                                               (void *)boxshapemono;

    /* Set starting position to the center */

    px = hgetmaxpx() / 2 - WIDTH / 2, py = hgetmaxpy() / 2 - HEIGHT / 2;

    /* Main loop */

    for (; ; ) {
        showsprite(px, py);

        c = getxch();
        if (c == ESC) break;
        switch (c) {
        case LEFTARROW:
            if (px >= STEP) px -= STEP;
            break;
        case RIGHTARROW:
            if (px + WIDTH - 1 + STEP <= hgetmaxpx()) px += STEP;
            break;
        case UPARROW:
            if (py >= 32 + STEP) py -= STEP;
            break;
        case DOWNARROW:
            if (py + HEIGHT - 1 + STEP <= hgetmaxpy()) py += STEP;
            break;
        }

        hidesprite();
    }
}
