/* File EX_SCROL.C: An example of the hscroll... functions */

#include <alloc.h>
#include <ctype.h>
#include <string.h>
#include <time.h>

#include "ascii.h"
#include "hancolor.h"
#include "hanlib.h"

void main(int argc, char *argv[])
{
    byte far *buffer;
    byte s[3] = "\0\0\0";
    byte msg[] = "eaa";
    int x, y, cnt = 0, len;
    long size;
    clock_t start, end;

    /* Check the argument */

    if (argc <= 1)
        puterr("Usage: ex_scrol option\r\n\n"
               "Options to select graphics mode\r\n"
               "  /a : Autodetection\r\n"
               "  /h : HGC(hercules) 640x480x2 mode\r\n"
               "  /e : EGA 640x350x16 mode\r\n"
               "  /v : VGA 640x480x16 mode\r\n"
               "  /8 : Super VGA 800x600x16 mode\r\n", 1);

    /* Initialize the library with the spacified graphics mode */

    switch (tolower(argv[1][1])) {
    case 'a':
        inithanlib(STDMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
        break;
    case 'h':
        inithanlib(STDMODE, HANHGC, DEFHANFONT, DEFENGFONT);
        break;
    case 'e':
        inithanlib(STDMODE, HANEGA, DEFHANFONT, DEFENGFONT);
        break;
    case 'v':
        inithanlib(STDMODE, HANVGA, DEFHANFONT, DEFENGFONT);
        break;
    case '8':
        inithanlib(HIRESSTDMODE, HANSVGA800LO, DEFHANFONT, DEFENGFONT);
        break;
    default:
        puterr("Illegal option!", 1);
    }

    if (hgraphresult() < NOERROR)
        puterr("This video adapter does not support"
               " the specified graphics mode!", 1);

    /* Allocate memory to rotate the screen */

    size = htextsize(1, 1, hgetmaxx(), 1);
    buffer = farmalloc(size);
    if (buffer == NULL) puterr("Not enough memory", 1);

    /* Confirue the screen */

    len = strlen(msg);
    for (y = 1; y < hgetmaxy(); y++)
        for (x = 1; x <= hgetmaxx(); x += 2) {
            s[0] = msg[(x - 1) % len];
            s[1] = msg[(x - 1) % len + 1];
            if (hgetmaxcolor() == 2) hsetreverse((x / 2 + y) & 1);
            else hsetbkcolor(x / 2 + y);
            hputsxy(x, y, s);
        }

    /* Print message */

    registerhanfont(HAN8GD1);
    hsetbkcolor(DARKGRAY);
    hsetreverse(false);
    hclrscrxy(1, hgetmaxy(), hgetmaxx(), hgetmaxy());
    hsetbkcolor(RED);
    hprintfxy(1, hgetmaxy(), " a iAa aAa... ");
    hsetbkcolor(DARKGRAY);
    hprintfxy(hgetmaxx() - 8, hgetmaxy(), "ESC a");

    /* Wait for a key */

    pause();
    hprintfxy(1, hgetmaxy(), "                         ");

    /* Main loop */

    start = clock();
    do {
        /* Rorate the screen */

        hgettext(1, 1, hgetmaxx(), 1, buffer);
        hscrollxy(1, 1, hgetmaxx(), hgetmaxy() - 1, _CW->linespace);
        hputtext(1, hgetmaxy() - 1, hgetmaxx(), hgetmaxy() - 1, buffer);

        /* Print elapsed time for rotating */

        if (++cnt % hgetmaxy() == 0) {
            end = clock();
            hprintfxy(2, hgetmaxy(), "e A e: %.2f ",
                      (end - start) / CLK_TCK);
            start = clock();
        }

    } while (getkey() != ESC);
}
