/* File EX_SCANF.C: An example of the hscanf function */

#include <dos.h>

#include "hanin.h"
#include "hanlib.h"

void beep(void)
{
    sound(1000);
    delay(100);
    nosound();
}

void main(void)
{
    int i, result;
    double x;

    /* Initialize Hangul lib */

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 15);

    /* Initialize the delay function */

    delay(0);

    /* Clear the entire screen */

    hsetbkcolor(HDARKGRAY);
    hclrscr();

    /* Print the title */

    hsetreverse(true);
    hprintf("<<< hscanf q b  >>>\r\n\n");
    hsetreverse(false);

    /* Get a value and check validity */

    do {
        hprintf("á aai baAa: ");
        result = hscanf("%le", &x);
        if (result != 1) beep();
    } while (result != 1);

    /* Print the value */

    hprintf("bE á: %.16g\r\n", x);

    /* Wair for a key */

    hprintf("\na iAa aAa...");
    pause();
}
