/* File EX_RGHAN.C: An example of the registerhanfont function */

#include "ascii.h"
#include "hanlib.h"

#include "disptext.inc"

void main(void)
{
    int c, fontnum = -1;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    hsetallcolormap();

    /* Print usage */

    hputsxy(1, 1, "ESC a");

    /* Main loop */

    do {
        /* Change the Hangul font */

        switch (fontnum = ++fontnum % 6) {
        case 0: registerhanfont(HAN10MD1);
                break;
        case 1: registerhanfont(HAN8GD1);
                break;
        case 2: registerhanfont(HAN412GS1);
                break;
        case 3: registerhanfont(HAN212MD1);
                break;
        case 4: registerhanfont(HAN212GD1);
                break;
        case 5: registerhanfont(HAN113GD1);
                break;
        }

        /* Display text */

        display_text(fontnum);

        /* When space bar pressed, pause displaying */

        if ((c = getkey()) == ' ') while (!keypressed());

    } while (c != ESC);
}
