/* File EX_RGENG.C: An example of the registerengfont function */

#include "ascii.h"
#include "hanlib.h"

char *engfont_title[13] = {
    " w a w  1 (ei aAw) ",
    " w a w  2 (ei aAw) ",
    " w a w  3 (ei eAw) ",
    " w a w  4 (ei eAw) ",
    " w a   5 (ei eAw) ",
    " w a w  6 (ei aAw) ",
    " w a  e 6 (ei aAw) ",
    " w  w  1 (ei aAw) ",
    " w   e 2 (ei aAw) ",
    " w  wa    3 (ei aAw) ",
    " w  aa    4 (ei aAw) ",
    " w  ȉ    5 (ei aAw) ",
    " w  ϩA    6 (ei aAw) ",
};

char *engfont_name[13] = {
    " aw: ENGMD1  ",
    " aw: ENGMD2  ",
    " aw: ENGMD3  ",
    " aw: ENGMD4  ",
    " aw: ENGGD5  ",
    " aw: ENGMD6  ",
    " aw: ENGGS6  ",
    " aw: ENGAUX1 ",
    " aw: ENGAUX2 ",
    " aw: ENGAUX3 ",
    " aw: ENGAUX4 ",
    " aw: ENGAUX5 ",
    " aw: ENGAUX6 ",
};

char *msg[7] = {
    " ea   : ",
    " E¬墅a : ",
    " 3aa  : ",
    " aa   : ",
    " qwa   : ",
    " bwa   : ",
    " a   : ",
};

void display_text(int fontnum)
{
    int i, attrnum;

    hsettextjustify(CENTER_TEXT);

    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HRED);
    hputsxy(hgetmaxx() / 2, 3, engfont_title[fontnum]);
    hsetreverse(false);
    hsetcolor(HWHITE), hsetbkcolor(HBLACK);
    hputsxy(hgetmaxx() / 2, 4, engfont_name[fontnum++]);

    hsetreverse(true);
    hsetbkcolor(HBLACK), hsetcolor(HYELLOW);
    hputsxy(hgetmaxx() / 2, 6, "--------<< ɷa >>--------");
    hsetreverse(false);

    hsetcolor(HWHITE), hsetbkcolor(_colormap[1 + fontnum % 7]);
    for (i = 0; i < 128; i++)
        _eputchxy(i, 9 + i % 64, 8 + i / 64);

    hsetreverse(true);
    hsetbkcolor(HBLACK), hsetcolor(HYELLOW);
    hputsxy(hgetmaxx() / 2, 11, "--------<< ewa >>--------");
    hsetreverse(false);

    hsetcolor(HWHITE), hsetbkcolor(_colormap[1 + fontnum % 7]);
    for (attrnum = 0; attrnum < 7; attrnum++) {
        hnormattr();
        switch (attrnum) {
        case 0: hsetbold(true);
                break;
        case 1: hsetoutline(true);
                break;
        case 2: hsetthreed(true);
                break;
        case 3: hsetfaint(true);
                break;
        case 4: hsetshadow(true);
                break;
        case 5: hsetreverse(true);
                break;
        case 6: hsetunder(true);
                break;
        }

        hgotoxy(1, 13 + attrnum);
        hputs(msg[attrnum]);
        hputs(" 0123456789 ");
        hputs("ABCDEFGHIJKLMNOPQRSTUVWXYZ ");
        hputs("abcdefghijklmnopqrstuvwxyz ");
    }
    hnormattr();

    hsetunder(true);
    hsetcolor(HLIGHTCYAN), hsetbkcolor(HBLACK);
    hputsxy(hgetmaxx() / 2, hgetmaxy() - 2,
            " aAaai ae q a. ");
    hsetunder(false);
}

void main(void)
{
    int c, fontnum = -1;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, HAN8GD1, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    hsetallcolormap();

    /* Print usage */

    hputsxy(1, 1, "ESC a");

    /* Main loop */

    do {
        /* Change the English font */

        registerhanfont(HAN8GD1);
        registerauxfont(NULL);  /* Cancel use of ENGAUXx font */

        switch (fontnum = ++fontnum % 13) {
        case 0:  registerengfont(ENGMD1);
                 break;
        case 1:  registerengfont(ENGMD2);
                 break;
        case 2:  registerengfont(ENGMD3);
                 registerhanfont(HAN212GD1);
                 break;
        case 3:  registerengfont(ENGMD4);
                 registerhanfont(HAN212GD1);
                 break;
        case 4:  registerengfont(ENGGD5);
                 registerhanfont(HAN212GD1);
                 break;
        case 5:  registerengfont(ENGMD6);
                 break;
        case 6:  registerengfont(ENGGS6);
                 break;
        case 7:  registerauxfont(ENGAUX1);
                 break;
        case 8:  registerauxfont(ENGAUX2);
                 break;
        case 9:  registerauxfont(ENGAUX3);
                 break;
        case 10: registerauxfont(ENGAUX4);
                 break;
        case 11: registerauxfont(ENGAUX5);
                 break;
        case 12: registerauxfont(ENGAUX6);
                 break;
        }

        /* Display text */

        display_text(fontnum);

        /* When space bar pressed, pause displaying */

        if ((c = getkey()) == ' ') while (!keypressed());

    } while (c != ESC);
}
