/* File EX_PTEXT.C: An example of the hgettext and the hputtext functions */

#include <alloc.h>

#include "hanlib.h"

#define WIDTH 48
#define HEIGHT 12

void main(void)
{
    byte far *buffer;
    int x, y;
    long size;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, NULL, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Draw an image */

    for (y = 0; y < HEIGHT * 16; y++)
        for (x = 0; x < WIDTH * 8; x++)
            hputpixel(x, y, (x + y) % (hgetmaxcolor() + 1));

    /* Print free memory and required size */

    size = htextsize(1, 1, -WIDTH, -HEIGHT);
    htempwindow(50, 1, 80, 25);
    hprintf("Free memory     : %ld bytes\n", farcoreleft());
    hprintf("Required memory : %ld bytes\n", size);
    hprintf("\nPress any key\n");
    hprintf("to copy a image below...\n");
    hlastwindow();

    /* Allocate memory */

    buffer = farmalloc(size);
    if (buffer == NULL) puterr("Not enough memory", 1);

    /* Wait for a key */

    pause();

    /* Get the image in text coordinates */

    hgettext(1, 1, -WIDTH, -HEIGHT, buffer);

    /* Put(copy) the image in text coordinates */

    hputtext(1, 14, -WIDTH, -HEIGHT, buffer);

    /* Wait for a key */

    pause();
}
