/* File EX_PIE.C: An example of BGI functions */

#include <math.h>
#include <stdlib.h>
#include <time.h>


#include "ascii.h"
#include "hanbgi.h"
#include "hanlib.h"

#define adjasp(y) ((int)(aspectratio * (double)(y)))
#define torad(d) ((double)(d) * M_PI / 180.)

double aspectratio;

void mainwindow(char *header)
{
    hsetcolor(hgetmaxcolor());
    hwindow(1, 1, hgetmaxax(), hgetmaxay());
    hclrscr();

    hsettextjustify(CENTER_TEXT);
    hputspxy(hgetmaxpx() / 2, 4, header);

    hwindow(1, 2, hgetmaxax(), hgetmaxay());
    drawborder(hgetmaxcolor());
}

void changetextstyle(int font, int direction, int charsize)
{
    int errorcode;

    graphresult();
    settextstyle(font, direction, charsize);
    errorcode = graphresult();
    if (errorcode != grOk)
        printerr(EXIT_FAILURE, " Graphics System Error: %s\n",
                 grapherrormsg(errorcode));
}

void piedemo(void)
{
    struct viewporttype vp;
    int xcenter, ycenter, radius, lradius;
    int x, y;
    double radians, piesize;

    mainwindow("  aa  ");

    getviewsettings(&vp);
    xcenter = (vp.right - vp.left) / 2;
    ycenter = (vp.bottom - vp.top) / 2 + 20;
    radius  = (vp.bottom - vp.top) / 3;
    piesize = (vp.bottom - vp.top) / 4.0;

    while ((aspectratio * radius) < piesize) radius++;

    lradius = radius + (radius / 5);

    changetextstyle(TRIPLEX_FONT, HORIZ_DIR, 4);
    settextjustify(CENTER_TEXT, TOP_TEXT);
    outtextxy(hgetmaxpx() / 2, 20, "This is a Pie Chart");
    changetextstyle(TRIPLEX_FONT, HORIZ_DIR, 1);
    settextjustify(CENTER_TEXT, TOP_TEXT);

    setfillstyle(SOLID_FILL, RED);
    pieslice(xcenter + 10, ycenter - adjasp(10), 0, 90, radius);
    radians = torad(45);
    x = xcenter + (int)(cos(radians) * (double)lradius);
    y = ycenter - (int)(sin(radians) * (double)lradius * aspectratio);
    settextjustify(LEFT_TEXT, BOTTOM_TEXT);
    outtextxy(x, y, "25 %");

    setfillstyle(WIDE_DOT_FILL, GREEN);
    pieslice(xcenter, ycenter, 90, 135, radius);
    radians = torad(113);
    x = xcenter + (int)(cos(radians) * (double)lradius);
    y = ycenter - (int)(sin(radians) * (double)lradius * aspectratio);
    settextjustify(RIGHT_TEXT, BOTTOM_TEXT);
    outtextxy(x, y, "12.5 %");

    setfillstyle(INTERLEAVE_FILL, YELLOW);
    settextjustify(RIGHT_TEXT, CENTER_TEXT);
    pieslice(xcenter - 10, ycenter, 135, 225, radius);
    radians = torad(180);
    x = xcenter + (int)(cos(radians) * (double)lradius);
    y = ycenter - (int)(sin(radians) * (double)lradius * aspectratio);
    settextjustify(RIGHT_TEXT, CENTER_TEXT);
    outtextxy(x, y, "25 %");

    setfillstyle(HATCH_FILL, BLUE);
    pieslice(xcenter, ycenter, 225, 360, radius);
    radians = torad(293);
    x = xcenter + (int)(cos(radians) * (double)lradius);
    y = ycenter - (int)(sin(radians) * (double)lradius * aspectratio);
    settextjustify(LEFT_TEXT, TOP_TEXT);
    outtextxy(x, y, "37.5 %");

    pause();
}

void bardemo(void)
{
    int barheight[] = {1, 3, 5, 2, 4};
    int styles[] = {1, 3, 10, 5, 9, 1};
    int xstep, ystep;
    int sheight, swidth;
    int i, j, h;
    struct viewporttype vp;
    char buffer[40];

    mainwindow(" b aa  ");

    h = 2 * textheight("H");
    getviewsettings(&vp);
    settextjustify(CENTER_TEXT, TOP_TEXT);
    changetextstyle(TRIPLEX_FONT, HORIZ_DIR, 4);
    outtextxy(hgetmaxpx() / 2, 20, "These are 2-D Bars");
    changetextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    setviewport(vp.left + 50, vp.top + 30, vp.right - 50, vp.bottom - 10, 1);

    getviewsettings(&vp);
    sheight = vp.bottom - vp.top;
    swidth  = vp.right  - vp.left;

    line(h, h, h, sheight - h);
    line(h, sheight - h, sheight - h, sheight - h);
    ystep = (sheight - (2 * h)) / 5;
    xstep = (swidth  - (2 * h)) / 5;
    j = sheight - h;
    settextjustify(CENTER_TEXT, CENTER_TEXT);

    for (i = 0 ; i < 6 ; i++){
        line(h / 2, j, h, j);
        itoa(i, buffer, 10);
        outtextxy(0, j, buffer);
	j -= ystep;
    }

    j = h;
    randomize();
    settextjustify(CENTER_TEXT, TOP_TEXT);
    for (i = 0; i < 6 ; i++) {
        setfillstyle(styles[i], random(getmaxcolor()));
        line(j, sheight - h, j, sheight - 3 - (h / 2));
        itoa(i, buffer, 10);
        outtextxy(j, sheight - (h / 2), buffer);
        if (i != 5){
            bar(j, (sheight - h) - (barheight[i] * ystep),
                j + xstep, sheight - h - 1);
            rectangle(j, (sheight - h) - (barheight[i] * ystep),
                      j + xstep, sheight - h);
        }
        j += xstep;
    }

    pause();
}

void main(void)
{
    int xasp, yasp;

    /* Initialize the library, BGI Mode, Autodetecting */

    inithanlib(BGIMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    /* Get aspect ratio */

    getaspectratio(&xasp, &yasp);
    aspectratio = (double)xasp / (double)yasp;

    /* Pie drawing demo */

    piedemo();

    /* Bar drawing demo */

    bardemo();
}
