/* File EX_MOU.C: An example of the Mouse Event Handler */

#include <alloc.h>

#include "ascii.h"
#include "hanbgi.h"
#include "hanlib.h"
#include "hanmou.h"

#define BOX1X 100
#define BOX1Y 100
#define BOX2X 440
#define BOX2Y 100

#define BOXWIDTH  100
#define BOXHEIGHT 100

byte far *buffer;

void hrectangle(int px1, int py1, int px2, int py2, int color)
{
    hhline(px1, py1, px2 - px1 + 1, color);
    hhline(px1, py2, px2 - px1 + 1, color);
    hvline(px1, py1, py2 - py1 + 1, color);
    hvline(px2, py1, py2 - py1 + 1, color);
}

void config_screen(void)
{
    int y;

    mou_hide();

    /* Clear the entire screen */

    hsetbkcolor(HDARKGRAY);
    hclrscr();

    /* Configure the background */

    for (y = 16 * 5; y <= hgetmaxpy() - 16; y++)
        hhline(0, y, hgetpwidth(), _colormap[y % 16]);

    /* Print title */

    hsetbkcolor(HCYAN);
    hclrscrxy(1, 1, 80, 1);
    hsetcolor(HCYAN);
    hsetbkcolor(HYELLOW);
    hsetreverse(true);
    hprintfxy(2, 1, "aa a é w ");
    hprintfxy(70, 1, "<ESC> a");
    hsetreverse(false);

    /* Print usage */

    hsetcolor(HWHITE);
    hsetbkcolor(HDARKGRAY);
    hgotoxy(1, 2);
    hprintf(" aa i e wba a .\n");
    hprintf(" <Space>i ae y  wb i a.\n");
    hprintf(" wb i  eAe"
            " aaa   aA a.\n");
    hprintf(" aaa e ba ỡe,"
            " e a AQi ·a.\n");

    /* Draw box frames */

    hrectangle(BOX1X - 1, BOX1Y - 1, BOX1X + BOXWIDTH, BOX1Y + BOXHEIGHT,
               HYELLOW);
    hrectangle(BOX2X - 1, BOX2Y - 1, BOX2X + BOXWIDTH, BOX2Y + BOXHEIGHT,
               HYELLOW);

    mou_show();
}

void print_bitmapxy(byte data)
{
    int i;

    for (i = 0; i < 8; i++)
        if ((data << i) & 0x80) hputs("*");
        else hputs("-");
}

void print_status(void)
{
    hgotoxy(1, hgetmaxy());

    /* Current event */

    hprintf(" Ea ");
    print_bitmapxy(_moucurevn);

    /* Button status */

    hprintf("            e wȁ [L=%d,R=%d,C=%d]",
            mou_isldown(), mou_isrdown(), mou_iscdown());

    /* Coordinates of hot spot */

    hprintf("             [%3d,%3d]", mou_getpx(), mou_getpy());
}

void hrotatepxy(int px1, int py1, int px2, int py2)
{
    if (px2 < 0) px2 = px1 + (-px2) - 1;
    if (py2 < 0) py2 = py1 + (-py2) - 1;

    hgetimage(px1, py1, px2, py1, buffer);
    hscrollpxy(px1, py1, px2, py2, 1);
    hputimage(px1, py2, buffer);
}

void rotate_area(bool active)
{
    static int cnt, cnt2;

    if (active) {
        setcolor(cnt % 16);
        circle(hgetmaxpx() / 2, hgetmaxpy() / 2, 30 + cnt % 70);
        hrotatepxy(BOX2X, BOX2Y, -BOXWIDTH, -BOXHEIGHT);
    }

    hrotatepxy(BOX1X, BOX1Y, -BOXWIDTH, -BOXHEIGHT);

    if (++cnt % 5 == 0) {
        hprintfxy(31 + cnt2 % 20, 7, " ");
        cnt2++;
        hprintfxy(31 + cnt2 % 20, 7, "%d", cnt2 % 10);
    }
}

void process_event(void)
{
    int moupx, moupy;

    /* Get coordinates of the hot spot of the last event */

    moupx = mou_getpx();
    moupy = mou_getpy();

    /* Check the left-button-pressed event */

    if (mou_isldownevn()) {
        hsolidbarpxy(moupx - 3, moupy - 3, moupx + 3, moupy + 3, HYELLOW);
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HLIGHTRED);
    }

    /* Check the left-button-released event */

    if (mou_islupevn()) {
        hsolidbarpxy(moupx - 3, moupy - 3, moupx + 3, moupy + 3, HBLACK);
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HRED);
    }

    /* Check the left-button-dragged event */

    if (mou_isldown() && mou_ismovevn())
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HWHITE);

    mou_clrevn();
}

void main(void)
{
    bool active = true;
    int i, c, index;
    long size;

    /* Initialize the library, BGI Mode, Autodetecting */

    inithanlib(BGIMODE, HANDETECT, HAN8GD1, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 2 % 2);

    /* Allocate memory for rotation */

    size = himagesize(0, 0, -hgetpwidth(), -1);
    buffer = farmalloc(size);
    if (buffer == NULL) puterr("Out of memory!", 1);

    /* Initialize the Mouse Event Handler with MOU_ARROW */

    mou_init(MOU_ARROW);

    /* Set the mouse window */

    mou_setwindow(1, 6, hgetmaxx(), hgetmaxy() - 1);

    /* Configure the screen */

    config_screen();

    /* Set a user-defined autohidden area */

    index = mou_sethidareapxy(BOX2X, BOX2Y, -BOXWIDTH, -BOXHEIGHT);
    if (index == ERROR) puterr("Out of memory!", 1);

    /* Shot the mouse cursor */

    mou_show();

    /* Main loop */

    while ((c = getkey()) != ESC) {
        if (c == ' ') {
            if (mou_ishidarea(index)) mou_removehidarea(index);
            else index = mou_sethidarea(BOX2X, BOX2Y, -BOXWIDTH, -BOXHEIGHT);
            active = !active;
        }

        rotate_area(active);

        if (mou_isanyevn()) {
            print_status();
            if (mou_isdisplayed()) process_event();
        }
    }
}
