/* File EX_MEQ.C: An example of the Mouse Event Queue */

#include "ascii.h"
#include "hanlib.h"
#include "hanmeq.h"
#include "hanmou.h"

void config_screen(void)
{
    int y;

    mou_hide();

    /* Clear the entire screen */

    hsetbkcolor(HGREEN);
    hclrscr();

    /* Configure the background */

    for (y = 16; y <= hgetmaxpy() - 16; y++)
        hhline(0, y, hgetpwidth(), _colormap[y % 16]);

    /* Print usage */

    hprintfxy(1, 1, " E ei a Va Ё ."
              "           <ESC> a, <Space> e ");

    mou_show();
}

void print_bitmapxy(word data)
{
    int i;

    for (i = 0; i < 16; i++)
        if ((data << i) & 0x8000) hputs("*");
        else hputs("-");
}

void print_status(void)
{
    hgotoxy(1, 25);

    /* Current event */

    hprintf(" Ea ");
    print_bitmapxy(meq_getcurevn());

    /* Button status */

    hprintf("        e wȁ [L=%d,R=%d,C=%d]",
            mou_isldown(), mou_isrdown(), mou_iscdown());

    /* Coordinates of hot spot */

    hprintf("         [%3d,%3d]", mou_getpx(), mou_getpy());
}

void process_event(void)
{
    int moupx, moupy;
    mouevnque_t *mouevn;

    /* Get a event from the queue */

    mouevn = meq_getevn();

    /* Get coordinates of the hot spot from the event */

    moupx = meq_getpx(mouevn);
    moupy = meq_getpy(mouevn);

    /* Check the double click and the left-button-pressed events */

    if (meq_isldblclickevn(mouevn))
        hsolidbarpxy(moupx - 5, moupy - 5, moupx + 5, moupy + 5, HCYAN);
    else if (meq_isldownevn(mouevn)) {
        hsolidbarpxy(moupx - 3, moupy - 3, moupx + 3, moupy + 3, HYELLOW);
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HLIGHTRED);
    }

    /* Check the left-button-released event */

    if (meq_islupevn(mouevn)) {
        hsolidbarpxy(moupx - 3, moupy - 3, moupx + 3, moupy + 3, HBLACK);
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HRED);
    }

    /* Check the left-button-dragged event */

    if (meq_isldragevn(mouevn))
        hsolidbarpxy(moupx - 1, moupy - 1, moupx + 1, moupy + 1, HWHITE);
}

void main(void)
{
    int i, c;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, HAN8GD1, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i % 2);

    /* Initialize the Mouse Event Queue with MOU_ARROW */

    meq_init(MOU_ARROW);

    /* Set the mouse window */

    mou_setwindow(1, 2, hgetmaxx(), hgetmaxy() - 1);

    /* Configure the screen */

    config_screen();

    /* Shot the mouse cursor */

    mou_show();

    /* Main loop */

    while ((c = getkey()) != ESC) {
        if (c == ' ') config_screen();

        print_status();

        while (!meq_isempty()) process_event();
    }
}
