/* File EX_LINE.C: An example of the hhline and the hvline functions */

#include "hanlib.h"

void main(void)
{
    int i, j;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, NULL, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i % 2);

    /* Draw vertival lines */

    for (j = 0; j < 10; j++)
        for (i = 0; i < 400; i++)
            hvline(120 + i, 0, i + 1, _colormap[(i + j) % 16]);

    /* Draw horizontal lines */

    for (j = 0; j < 30; j++)
        for (i = 0; i < 400; i++)
            hhline(120 + 0, i, i + 1, _colormap[(i + j) % 16]);

    /* Wait for a dummy input */

    pause();
}
